/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.configuration;

import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadResourceServerProperties;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
public class AadPropertiesConfiguration {
    private final AzureGlobalProperties global;

    AadPropertiesConfiguration(AzureGlobalProperties global) {
        this.global = global;
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.azure.active-directory")
    @ConditionalOnMissingBean
    public AadAuthenticationProperties aadAuthenticationProperties() {
        AadAuthenticationProperties aad = new AadAuthenticationProperties();
        aad.getProfile().setCloudType(this.global.getProfile().getCloudType());
        aad.getProfile().getEnvironment().setActiveDirectoryEndpoint(this.global.getProfile().getEnvironment().getActiveDirectoryEndpoint());
        aad.getProfile().getEnvironment().setMicrosoftGraphEndpoint(this.global.getProfile().getEnvironment().getMicrosoftGraphEndpoint());
        aad.getCredential().setClientId(this.global.getCredential().getClientId());
        aad.getCredential().setClientSecret(this.global.getCredential().getClientSecret());
        aad.getProfile().setTenantId(this.global.getProfile().getTenantId());
        return aad;
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.azure.active-directory.resource-server")
    @ConditionalOnMissingBean
    AadResourceServerProperties aadResourceServerProperties() {
        return new AadResourceServerProperties();
    }
}

