/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.jackson;

import com.azure.spring.cloud.autoconfigure.aad.implementation.jackson.AadOAuth2ClientJackson2Module;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.jackson2.CoreJackson2Module;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.jackson2.OAuth2ClientJackson2Module;

public class SerializerUtils {
    private static final ObjectMapper OBJECT_MAPPER;
    private static final TypeReference<Map<String, OAuth2AuthorizedClient>> TYPE_REFERENCE;

    public static String serializeOAuth2AuthorizedClientMap(Map<String, OAuth2AuthorizedClient> authorizedClients) {
        String result;
        try {
            result = OBJECT_MAPPER.writeValueAsString(authorizedClients);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public static Map<String, OAuth2AuthorizedClient> deserializeOAuth2AuthorizedClientMap(String authorizedClientsString) {
        Map authorizedClients;
        if (authorizedClientsString == null) {
            return new HashMap<String, OAuth2AuthorizedClient>();
        }
        try {
            authorizedClients = (Map)OBJECT_MAPPER.readValue(authorizedClientsString, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return authorizedClients;
    }

    static {
        TYPE_REFERENCE = new TypeReference<Map<String, OAuth2AuthorizedClient>>(){};
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.registerModule((Module)new OAuth2ClientJackson2Module());
        OBJECT_MAPPER.registerModule((Module)new AadOAuth2ClientJackson2Module());
        OBJECT_MAPPER.registerModule((Module)new CoreJackson2Module());
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

