/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties;

import com.azure.spring.cloud.autoconfigure.implementation.storage.common.AzureStorageProperties;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientProperties;
import com.azure.storage.blob.BlobServiceVersion;

public class AzureStorageBlobProperties
extends AzureStorageProperties
implements BlobServiceClientProperties {
    public static final String PREFIX = "spring.cloud.azure.storage.blob";
    private static final String BLOB_ENDPOINT_PATTERN = "https://%s.blob%s";
    private String customerProvidedKey;
    private String encryptionScope;
    private BlobServiceVersion serviceVersion;
    private String containerName;
    private String blobName;

    @Override
    public String getEndpoint() {
        return this.endpoint == null ? this.buildEndpointFromAccountName() : this.endpoint;
    }

    private String buildEndpointFromAccountName() {
        return String.format(BLOB_ENDPOINT_PATTERN, this.accountName, this.profile.getEnvironment().getStorageEndpointSuffix());
    }

    public String getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public void setCustomerProvidedKey(String customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public void setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(BlobServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public void setBlobName(String blobName) {
        this.blobName = blobName;
    }
}

