/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.keyvault.secrets;

import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={SecretClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.keyvault.secret.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.keyvault.secret", name={"endpoint"})
public class AzureKeyVaultSecretAutoConfiguration
extends AzureServiceConfigurationBase {
    AzureKeyVaultSecretAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.azure.keyvault.secret")
    AzureKeyVaultSecretProperties azureKeyVaultSecretProperties() {
        return this.loadProperties(this.getAzureGlobalProperties(), new AzureKeyVaultSecretProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretClient azureKeyVaultSecretClient(SecretClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretAsyncClient azureKeyVaultSecretAsyncClient(SecretClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    SecretClientBuilder secretClientBuilder(SecretClientBuilderFactory factory) {
        return (SecretClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    SecretClientBuilderFactory secretClientBuilderFactory(AzureKeyVaultSecretProperties properties, ObjectProvider<AzureServiceClientBuilderCustomizer<SecretClientBuilder>> customizers) {
        SecretClientBuilderFactory factory = new SecretClientBuilderFactory((SecretClientProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_KEY_VAULT_SECRETS);
        customizers.orderedStream().forEach(arg_0 -> ((SecretClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

