/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.jms.AzureServiceBusJmsCredentialSupplier;
import com.azure.spring.cloud.autoconfigure.implementation.jms.AzureServiceBusJmsPropertiesBeanPostProcessor;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsConnectionFactoryConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsContainerConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsPasswordlessConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureServiceBusResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.jms.ServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzurePasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import jakarta.jms.ConnectionFactory;
import java.util.HashMap;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsTemplate;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={JndiConnectionFactoryAutoConfiguration.class, AzureServiceBusResourceManagerAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.jms.servicebus.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ConnectionFactory.class, JmsConnectionFactory.class, JmsTemplate.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={ServiceBusJmsPasswordlessConfiguration.class, ServiceBusJmsConnectionFactoryConfiguration.class, ServiceBusJmsContainerConfiguration.class})
public class ServiceBusJmsAutoConfiguration {
    @Bean
    AzureServiceBusJmsProperties serviceBusJmsProperties(AzureGlobalProperties azureGlobalProperties) {
        AzureServiceBusJmsProperties properties = new AzureServiceBusJmsProperties();
        return this.mergeAzureProperties(azureGlobalProperties, properties);
    }

    @Bean
    @ConditionalOnExpression(value="'premium'.equalsIgnoreCase('${spring.jms.servicebus.pricing-tier}')")
    ServiceBusJmsConnectionFactoryCustomizer amqpOpenPropertiesCustomizer(ObjectProvider<AzureServiceBusJmsCredentialSupplier> azureServiceBusJmsCredentialSupplier) {
        return factory -> {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("com.microsoft:is-client-provider", true);
            if (azureServiceBusJmsCredentialSupplier.getIfAvailable() != null) {
                properties.put("user-agent", AzureSpringIdentifier.AZURE_SPRING_PASSWORDLESS_SERVICE_BUS);
            } else {
                properties.put("user-agent", AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            }
            factory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> properties);
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingProperty(prefix="spring.jms.servicebus", name={"connection-string"})
    static AzureServiceBusJmsPropertiesBeanPostProcessor azureServiceBusJmsPropertiesBeanPostProcessor(ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders) {
        return new AzureServiceBusJmsPropertiesBeanPostProcessor(connectionStringProviders);
    }

    private AzureServiceBusJmsProperties mergeAzureProperties(AzureGlobalProperties azureGlobalProperties, AzureServiceBusJmsProperties azurePasswordlessProperties) {
        AzureServiceBusJmsProperties mergedProperties = new AzureServiceBusJmsProperties();
        AzurePasswordlessPropertiesUtils.mergeAzureCommonProperties((AzureProperties)azureGlobalProperties, (PasswordlessProperties)azurePasswordlessProperties, (PasswordlessProperties)mergedProperties);
        return mergedProperties;
    }
}

