/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsConnectionFactoryFactory;
import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.jms.ServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.jms.ServiceBusJmsConnectionFactory;
import jakarta.jms.ConnectionFactory;
import java.util.stream.Collectors;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ServiceBusJmsConnectionFactoryConfiguration {
    ServiceBusJmsConnectionFactoryConfiguration() {
    }

    private static ServiceBusJmsConnectionFactory createJmsConnectionFactory(AzureServiceBusJmsProperties properties, ObjectProvider<ServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
        return new ServiceBusJmsConnectionFactoryFactory(properties, factoryCustomizers.orderedStream().collect(Collectors.toList())).createConnectionFactory(ServiceBusJmsConnectionFactory.class);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="spring.jms.servicebus.pool", name={"enabled"}, havingValue="true")
        JmsPoolConnectionFactory jmsPoolConnectionFactory(AzureServiceBusJmsProperties properties, ObjectProvider<ServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
            ServiceBusJmsConnectionFactory factory = ServiceBusJmsConnectionFactoryConfiguration.createJmsConnectionFactory(properties, factoryCustomizers);
            return new JmsPoolConnectionFactoryFactory(properties.getPool()).createPooledConnectionFactory((ConnectionFactory)factory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.jms.servicebus.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    static class SimpleConnectionFactoryConfiguration {
        SimpleConnectionFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="false")
        ServiceBusJmsConnectionFactory jmsConnectionFactory(AzureServiceBusJmsProperties properties, ObjectProvider<ServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
            return ServiceBusJmsConnectionFactoryConfiguration.createJmsConnectionFactory(properties, factoryCustomizers);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={CachingConnectionFactory.class})
        @ConditionalOnProperty(prefix="spring.jms.cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class CachingConnectionFactoryConfiguration {
            CachingConnectionFactoryConfiguration() {
            }

            @Bean
            CachingConnectionFactory jmsConnectionFactory(JmsProperties jmsProperties, AzureServiceBusJmsProperties properties, ObjectProvider<ServiceBusJmsConnectionFactoryCustomizer> factoryCustomizers) {
                ServiceBusJmsConnectionFactory factory = ServiceBusJmsConnectionFactoryConfiguration.createJmsConnectionFactory(properties, factoryCustomizers);
                CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)factory);
                JmsProperties.Cache cacheProperties = jmsProperties.getCache();
                connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
                connectionFactory.setCacheProducers(cacheProperties.isProducers());
                connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
                return connectionFactory;
            }
        }
    }
}

