/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties;

import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureServicePropertiesUtils;
import com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties.AzureStorageBlobConnectionDetails;
import com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties.AzureStorageBlobProperties;
import com.azure.spring.cloud.autoconfigure.implementation.storage.common.AzureStorageProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectionDetails.class})
@ConditionalOnBean(value={AzureStorageBlobConnectionDetails.class})
class ConfigurationWithConnectionDetailsBean {
    private final Environment environment;
    private final AzureStorageBlobConnectionDetails connectionDetails;

    ConfigurationWithConnectionDetailsBean(Environment environment, AzureStorageBlobConnectionDetails connectionDetails) {
        this.environment = environment;
        this.connectionDetails = connectionDetails;
    }

    @Bean
    AzureStorageBlobProperties azureStorageBlobProperties(@Qualifier(value="azureStorageProperties") AzureStorageProperties azureStorageProperties) {
        AzureStorageBlobProperties propertiesLoadFromServiceCommonProperties = AzureServicePropertiesUtils.loadServiceCommonProperties(azureStorageProperties, new AzureStorageBlobProperties());
        BindResult bindResult = Binder.get((Environment)this.environment).bind("spring.cloud.azure.storage.blob", Bindable.ofInstance((Object)propertiesLoadFromServiceCommonProperties));
        AzureStorageBlobProperties properties = bindResult.isBound() ? (AzureStorageBlobProperties)bindResult.get() : propertiesLoadFromServiceCommonProperties;
        properties.setConnectionString(this.connectionDetails.getConnectionString());
        return properties;
    }
}

