/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.batch;

import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import io.github.bucket4j.util.concurrent.batch.AsyncBatchHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class AsyncBatchingExecutor
implements AsyncCommandExecutor {
    private final AsyncBatchHelper<RemoteCommand<?>, CommandResult<?>, MultiCommand, CommandResult<MultiResult>> batchingHelper;
    private final AsyncCommandExecutor wrappedExecutor;
    private final OptimizationListener listener;
    private final Function<List<RemoteCommand<?>>, MultiCommand> taskCombiner = new Function<List<RemoteCommand<?>>, MultiCommand>(){

        @Override
        public MultiCommand apply(List<RemoteCommand<?>> commands) {
            AsyncBatchingExecutor.this.listener.incrementMergeCount(commands.size() - 1);
            return new MultiCommand(commands);
        }
    };
    private final Function<MultiCommand, CompletableFuture<CommandResult<MultiResult>>> combinedTaskExecutor = new Function<MultiCommand, CompletableFuture<CommandResult<MultiResult>>>(){

        @Override
        public CompletableFuture<CommandResult<MultiResult>> apply(MultiCommand multiCommand) {
            return AsyncBatchingExecutor.this.wrappedExecutor.executeAsync(multiCommand);
        }
    };
    private final Function<RemoteCommand<?>, CompletableFuture<CommandResult<?>>> taskExecutor = new Function<RemoteCommand<?>, CompletableFuture<CommandResult<?>>>(){

        @Override
        public CompletableFuture<CommandResult<?>> apply(RemoteCommand<?> remoteCommand) {
            CompletableFuture<CommandResult<?>> future = AsyncBatchingExecutor.this.wrappedExecutor.executeAsync(remoteCommand);
            return future;
        }
    };
    private final Function<CommandResult<MultiResult>, List<CommandResult<?>>> combinedResultSplitter = new Function<CommandResult<MultiResult>, List<CommandResult<?>>>(){

        @Override
        public List<CommandResult<?>> apply(CommandResult<MultiResult> multiResult) {
            return multiResult.getData().getResults();
        }
    };

    public AsyncBatchingExecutor(AsyncCommandExecutor originalExecutor, OptimizationListener listener) {
        this.wrappedExecutor = originalExecutor;
        this.listener = listener;
        this.batchingHelper = AsyncBatchHelper.create(this.taskCombiner, this.combinedTaskExecutor, this.taskExecutor, this.combinedResultSplitter);
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CompletableFuture<CommandResult<T>> future = this.batchingHelper.executeAsync(command);
        return future;
    }
}

