/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.report;

import com.buschmais.jqassistant.core.report.api.model.source.ArtifactLocation;
import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import java.util.Optional;
import lombok.Generated;

public class FileSourceHelper {
    public static Optional<FileLocation> getSourceLocation(FileDescriptor descriptor, Optional<Integer> startLine, Optional<Integer> endLine) {
        String fileName = descriptor.getFileName();
        if (fileName != null) {
            FileLocation.FileLocationBuilder fileLocationBuilder = (FileLocation.FileLocationBuilder)FileLocation.builder().fileName(fileName);
            fileLocationBuilder.startLine(startLine);
            fileLocationBuilder.endLine(endLine);
            fileLocationBuilder.parent(FileSourceHelper.getParentLocation(descriptor));
            return Optional.of(fileLocationBuilder.build());
        }
        return Optional.empty();
    }

    public static Optional<ArtifactLocation> getParentLocation(FileDescriptor descriptor) {
        for (FileDescriptor parentDescriptor : descriptor.getParents()) {
            if (!(parentDescriptor instanceof ArtifactFileDescriptor)) continue;
            ArtifactFileDescriptor parentArtifactFileDescriptor = (ArtifactFileDescriptor)parentDescriptor;
            ArtifactLocation.ArtifactLocationBuilder artifactLocationBuilder = (ArtifactLocation.ArtifactLocationBuilder)ArtifactLocation.builder().fileName(parentArtifactFileDescriptor.getFileName());
            artifactLocationBuilder.group(Optional.ofNullable(parentArtifactFileDescriptor.getGroup())).name(Optional.ofNullable(parentArtifactFileDescriptor.getName())).version(Optional.ofNullable(parentArtifactFileDescriptor.getVersion())).type(Optional.ofNullable(parentArtifactFileDescriptor.getType())).classifier(Optional.ofNullable(parentArtifactFileDescriptor.getClassifier()));
            artifactLocationBuilder.parent(FileSourceHelper.getParentLocation(parentArtifactFileDescriptor));
            return Optional.of(artifactLocationBuilder.build());
        }
        return Optional.empty();
    }

    @Generated
    private FileSourceHelper() {
    }
}

