/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.shared.io.FileNameNormalizer;
import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractContainerScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractDirectoryResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.buschmais.jqassistant.plugin.common.impl.scanner.BufferedFileResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectoryScannerPlugin<D extends DirectoryDescriptor>
extends AbstractContainerScannerPlugin<File, File, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDirectoryScannerPlugin.class);
    public static final String PROPERTY_FOLLOW_SYMLINKS = "directory.follow-symbolic-links";

    @Override
    public Class<? extends File> getType() {
        return File.class;
    }

    @Override
    public Class<D> getDescriptorType() {
        return this.getTypeParameter(AbstractDirectoryScannerPlugin.class, 0);
    }

    public boolean accepts(File item, String path, Scope scope) throws IOException {
        return item.isDirectory() && this.getRequiredScope().equals(scope);
    }

    @Override
    protected Iterable<? extends File> getEntries(File container) throws IOException {
        final Path directoryPath = container.toPath();
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (!directoryPath.equals(dir)) {
                    files.add(dir.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                files.add(file.toFile());
                return FileVisitResult.CONTINUE;
            }
        };
        boolean followSymlinks = this.getBooleanProperty(PROPERTY_FOLLOW_SYMLINKS, false);
        if (followSymlinks) {
            log.info("Following symbolic links.");
            Files.walkFileTree(directoryPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        } else {
            Files.walkFileTree(directoryPath, (FileVisitor<? super Path>)visitor);
        }
        return files;
    }

    protected abstract Scope getRequiredScope();

    @Override
    protected String getContainerPath(File container, String path) {
        return FileNameNormalizer.normalize((String)path);
    }

    @Override
    protected String getRelativePath(File container, File entry) {
        return this.getDirectoryPath(container, entry);
    }

    @Override
    protected Resource getEntry(File container, File entry) {
        if (entry.isDirectory()) {
            return new DirectoryResource(entry.getPath());
        }
        return new BufferedFileResource(new FileResource(entry));
    }

    private static class DirectoryResource
    extends AbstractDirectoryResource {
        public DirectoryResource(String entryPath) {
            super(entryPath);
        }
    }

    private static class FileResource
    implements com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource {
        private final File entry;

        public FileResource(File entry) {
            this.entry = entry;
        }

        @Override
        public InputStream createStream() throws IOException {
            return new FileInputStream(this.entry);
        }

        @Override
        public File getFile() {
            return this.entry;
        }

        @Override
        public void close() {
        }
    }
}

