/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.impl.scanner.AbstractUriScannerPlugin;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;

public class PluginUriScannerPlugin
extends AbstractUriScannerPlugin<URL> {
    public static final String JQASSISTANT_PLUGIN = "jqassistant-plugin";
    public static final String PROPERTY_IGNORE_NON_EXISTING_RESOURCES = "jqassistant-plugin.ignore-non-existing-resources";
    private boolean ignoreNonExistingResources;

    @Override
    protected void configure() {
        this.ignoreNonExistingResources = this.getBooleanProperty(PROPERTY_IGNORE_NON_EXISTING_RESOURCES, false);
    }

    public boolean accepts(URI uri, String path, Scope scope) throws IOException {
        return JQASSISTANT_PLUGIN.equalsIgnoreCase(uri.getScheme());
    }

    @Override
    protected Optional<URL> getResource(URI uri, ScannerContext context) {
        return this.resolve(uri, () -> {
            URL resource = context.getClassLoader().getResource(uri.getSchemeSpecificPart());
            if (resource == null && !this.ignoreNonExistingResources) {
                throw new IllegalArgumentException("Cannot resolve resource '" + String.valueOf(uri) + "' from plugins.");
            }
            return resource;
        }, context);
    }
}

