/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Rule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Error;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Failure;
import com.buschmais.jqassistant.plugin.junit.impl.schema.ObjectFactory;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testcase;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testsuite;
import java.io.File;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

@ReportPlugin.Default
public class JUnitReportPlugin
implements ReportPlugin {
    public static final String JUNIT_REPORT_DIRECTORY = "junit.report.directory";
    public static final String JUNIT_FAILURE_SEVERITY = "junit.report.failureSeverity";
    public static final String JUNIT_ERROR_SEVERITY = "junit.report.errorSeverity";
    public static final String DEFAULT_JUNIT_REPORT_DIRECTORY = "junit";
    private static final String TESTSUITE_PREFIX = "jqassistant.Group";
    private JAXBContext jaxbContext;
    private File reportDirectory;
    private Deque<Group> groups = new LinkedList<Group>();
    private long ruleBeginTimestamp;
    private Map<Group, GroupInfo> results = new HashMap<Group, GroupInfo>();
    private Severity.Threshold failureSeverity = Severity.Threshold.from((Severity)Concept.DEFAULT_SEVERITY);
    private Severity.Threshold errorSeverity = Severity.Threshold.from((Severity)Constraint.DEFAULT_SEVERITY);

    public void initialize() throws ReportException {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new ReportException("Cannot create jaxb context instance.", (Throwable)e);
        }
    }

    public void configure(ReportContext reportContext, Map<String, Object> properties) throws ReportException {
        String errorSeverity;
        String junitReportDirectory = (String)properties.get(JUNIT_REPORT_DIRECTORY);
        this.reportDirectory = junitReportDirectory != null ? new File(junitReportDirectory) : reportContext.getReportDirectory(DEFAULT_JUNIT_REPORT_DIRECTORY);
        this.reportDirectory.mkdirs();
        String failureSeverity = (String)properties.get(JUNIT_FAILURE_SEVERITY);
        if (failureSeverity != null) {
            this.failureSeverity = this.getSeverity(failureSeverity);
        }
        if ((errorSeverity = (String)properties.get(JUNIT_ERROR_SEVERITY)) != null) {
            this.errorSeverity = this.getSeverity(errorSeverity);
        }
    }

    private Severity.Threshold getSeverity(String value) throws ReportException {
        try {
            return Severity.Threshold.from((String)value);
        }
        catch (RuleException e) {
            throw new ReportException("Cannot convert " + value + " to severity threshold.", (Throwable)e);
        }
    }

    public void begin() {
        this.pushGroup(null);
    }

    public void end() throws ReportException {
        this.popGroup(null);
    }

    public void beginGroup(Group group) {
        this.pushGroup(group);
    }

    public void endGroup() throws ReportException {
        Group group = this.groups.pop();
        this.popGroup(group);
    }

    public void beginConcept(Concept concept) {
        this.ruleBeginTimestamp = System.currentTimeMillis();
    }

    public void beginConstraint(Constraint constraint) {
        this.ruleBeginTimestamp = System.currentTimeMillis();
    }

    public void setResult(Result<? extends ExecutableRule> result) {
        long ruleEndTimestamp = System.currentTimeMillis();
        long time = ruleEndTimestamp - this.ruleBeginTimestamp;
        Group group = this.groups.peek();
        GroupInfo groupInfo = this.results.get(group);
        groupInfo.getResults().put(result, time);
    }

    private void pushGroup(Group group) {
        this.groups.push(group);
        this.results.put(group, new GroupInfo(System.currentTimeMillis()));
    }

    private void popGroup(Group group) throws ReportException {
        GroupInfo groupInfo = this.results.remove(group);
        Testsuite testsuite = new Testsuite();
        int tests = 0;
        int failures = 0;
        int errors = 0;
        String testSuiteId = this.getTestSuiteId(group);
        for (Map.Entry<Result<? extends ExecutableRule>, Long> entry : groupInfo.getResults().entrySet()) {
            Result<? extends ExecutableRule> result = entry.getKey();
            long time = entry.getValue();
            Testcase testcase = new Testcase();
            ExecutableRule rule = result.getRule();
            testcase.setName(rule.getClass().getSimpleName() + "_" + ReportHelper.escapeRuleId((Rule)rule));
            testcase.setClassname(testSuiteId);
            testcase.setTime(this.toTime(time));
            List rows = result.getRows();
            if (Result.Status.FAILURE.equals((Object)result.getStatus())) {
                StringBuilder sb = new StringBuilder();
                for (Row row : rows) {
                    Map columns = row.getColumns();
                    if (sb.length() > 0) {
                        sb.append("---\n");
                    }
                    for (Map.Entry columnEntry : columns.entrySet()) {
                        sb.append((String)columnEntry.getKey());
                        sb.append(" = ");
                        sb.append(((Column)columnEntry.getValue()).getLabel());
                        sb.append('\n');
                    }
                }
                String content = sb.toString();
                Severity severity = result.getSeverity();
                if (severity.exceeds(this.failureSeverity)) {
                    Failure failure = new Failure();
                    failure.setMessage(rule.getDescription());
                    failure.setContent(content);
                    testcase.getFailure().add(failure);
                    ++failures;
                } else if (severity.exceeds(this.errorSeverity)) {
                    Error error = new Error();
                    error.setMessage(rule.getDescription());
                    error.setContent(content);
                    testcase.getError().add(error);
                    ++errors;
                }
            }
            ++tests;
            testsuite.getTestcase().add(testcase);
        }
        testsuite.setTests(Integer.toString(tests));
        testsuite.setFailures(Integer.toString(failures));
        testsuite.setErrors(Integer.toString(errors));
        testsuite.setName(testSuiteId);
        long groupTime = System.currentTimeMillis() - groupInfo.getBeginTimestamp();
        testsuite.setTime(this.toTime(groupTime));
        File file = new File(this.reportDirectory, "TEST-" + testSuiteId + ".xml");
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)testsuite, file);
        }
        catch (JAXBException e) {
            throw new ReportException("Cannot write JUnit report.", (Throwable)e);
        }
    }

    private String toTime(long time) {
        return Double.toString(time / 1000L);
    }

    private String getTestSuiteId(Group group) {
        StringBuilder testSuiteIdBuilder = new StringBuilder(TESTSUITE_PREFIX);
        if (group != null) {
            testSuiteIdBuilder.append('_').append(ReportHelper.escapeRuleId((Rule)group));
        }
        return testSuiteIdBuilder.toString();
    }

    private static class GroupInfo {
        private final long beginTimestamp;
        private final Map<Result<? extends ExecutableRule>, Long> results = new HashMap<Result<? extends ExecutableRule>, Long>();

        GroupInfo(long beginTimestamp) {
            this.beginTimestamp = beginTimestamp;
        }

        long getBeginTimestamp() {
            return this.beginTimestamp;
        }

        Map<Result<? extends ExecutableRule>, Long> getResults() {
            return this.results;
        }
    }
}

