/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.PropertyFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.XmlPropertyFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlDocumentDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XMLFileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class, XmlDocumentDescriptor.class})
public class XmlPropertyFileScannerPlugin
extends AbstractScannerPlugin<FileResource, PropertyFileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlPropertyFileScannerPlugin.class);

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean hasXMLExtension = path.toLowerCase().endsWith(".xml");
        boolean isPropertyFile = hasXMLExtension ? XMLFileFilter.rootElementMatches((FileResource)item, (String)path, (String)"properties") : false;
        return hasXMLExtension && isPropertyFile;
    }

    public PropertyFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        Store store = context.getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        Class<XmlPropertyFileDescriptor> descriptorType = XmlPropertyFileDescriptor.class;
        PropertyFileDescriptor propertyFileDescriptor = (PropertyFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, descriptorType);
        Properties properties = new Properties();
        try (InputStream stream = item.createStream();){
            properties.loadFromXML(stream);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Cannot load properties from '" + path + "': " + e.getMessage());
        }
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(name);
            propertyDescriptor.setValue(value);
            propertyFileDescriptor.getProperties().add(propertyDescriptor);
        }
        return propertyFileDescriptor;
    }
}

