/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.EnumTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InterfaceTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.LambdaMethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PrimitiveValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VisibilityModifier;
import com.buschmais.jqassistant.plugin.java.api.model.generics.BoundDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.FieldVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodComplexityVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodLoCVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.delegate.DelegatingMethodVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.AbstractBoundVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.ClassSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.MethodSignatureVisitor;
import java.util.Arrays;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassVisitor
extends org.objectweb.asm.ClassVisitor {
    private static final String CONSTRUCTOR_METHOD = "<init>";
    private static final String LAMBDA_METHOD = "lambda$";
    private TypeCache.CachedType<? extends ClassFileDescriptor> cachedType;
    private FileDescriptor fileDescriptor;
    private VisitorHelper visitorHelper;

    public ClassVisitor(FileDescriptor fileDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.fileDescriptor = fileDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public ClassFileDescriptor getTypeDescriptor() {
        return this.cachedType != null ? this.cachedType.getTypeDescriptor() : null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Class<? extends ClassFileDescriptor> javaType = this.getJavaType(access);
        String fullQualifiedName = SignatureHelper.getObjectType(name);
        this.cachedType = this.visitorHelper.createType(fullQualifiedName, this.fileDescriptor, javaType);
        this.visitorHelper.getTypeVariableResolver().push();
        ClassFileDescriptor classFileDescriptor = this.cachedType.getTypeDescriptor();
        classFileDescriptor.setByteCodeVersion(version);
        if (this.hasFlag(access, 1024) && !this.hasFlag(access, 512)) {
            classFileDescriptor.setAbstract(Boolean.TRUE);
        }
        this.setModifiers(access, classFileDescriptor);
        if (signature == null) {
            if (superName != null) {
                Object superClassType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(superName), this.cachedType).getTypeDescriptor();
                classFileDescriptor.setSuperClass((TypeDescriptor)superClassType);
            }
            for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                Object interfaceType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(interfaces[i]), this.cachedType).getTypeDescriptor();
                classFileDescriptor.getInterfaces().add((TypeDescriptor)interfaceType);
            }
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new ClassSignatureVisitor(this.cachedType, this.visitorHelper));
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(this.cachedType, SignatureHelper.getFieldSignature(name, desc));
        fieldDescriptor.setName(name);
        fieldDescriptor.setVolatile(this.hasFlag(access, 64));
        fieldDescriptor.setTransient(this.hasFlag(access, 128));
        this.setModifiers(access, fieldDescriptor);
        if (signature == null) {
            Object type = this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.cachedType).getTypeDescriptor();
            fieldDescriptor.setType((TypeDescriptor)type);
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new AbstractBoundVisitor(this.visitorHelper, this.cachedType){

                @Override
                protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                    fieldDescriptor.setType(rawTypeBound);
                    fieldDescriptor.setGenericType(bound);
                }
            });
        }
        if (value != null) {
            if (value instanceof Type) {
                this.visitorHelper.resolveType(SignatureHelper.getType((Type)value), this.cachedType);
            }
            PrimitiveValueDescriptor valueDescriptor = this.visitorHelper.getValueDescriptor(PrimitiveValueDescriptor.class);
            valueDescriptor.setValue(value);
            fieldDescriptor.setValue(valueDescriptor);
        }
        return new FieldVisitor(this.cachedType, fieldDescriptor, this.visitorHelper);
    }

    public org.objectweb.asm.MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String methodSignature = SignatureHelper.getMethodSignature(name, desc);
        MethodDescriptor methodDescriptor = this.visitorHelper.getMethodDescriptor(this.cachedType, methodSignature);
        if (this.isLambda(name, access)) {
            this.visitorHelper.getStore().addDescriptorType((Descriptor)methodDescriptor, LambdaMethodDescriptor.class);
        }
        this.visitorHelper.getTypeVariableResolver().push();
        methodDescriptor.setName(name);
        this.setModifiers(access, methodDescriptor);
        if (this.hasFlag(access, 1024)) {
            methodDescriptor.setAbstract(Boolean.TRUE);
        }
        if (this.hasFlag(access, 256)) {
            methodDescriptor.setNative(Boolean.TRUE);
        }
        if (signature == null) {
            String returnType = SignatureHelper.getType(Type.getReturnType((String)desc));
            methodDescriptor.setReturns((TypeDescriptor)this.visitorHelper.resolveType(returnType, this.cachedType).getTypeDescriptor());
            Type[] types = Type.getArgumentTypes((String)desc);
            for (int i = 0; i < types.length; ++i) {
                String parameterType = SignatureHelper.getType(types[i]);
                Object typeDescriptor = this.visitorHelper.resolveType(parameterType, this.cachedType).getTypeDescriptor();
                ParameterDescriptor parameterDescriptor = this.visitorHelper.addParameterDescriptor(methodDescriptor, i);
                parameterDescriptor.setType((TypeDescriptor)typeDescriptor);
            }
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new MethodSignatureVisitor(this.cachedType, methodDescriptor, this.visitorHelper));
        }
        for (int i = 0; exceptions != null && i < exceptions.length; ++i) {
            Object exceptionType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(exceptions[i]), this.cachedType).getTypeDescriptor();
            methodDescriptor.getThrows().add((TypeDescriptor)exceptionType);
        }
        return new DelegatingMethodVisitor(Arrays.asList(new org.objectweb.asm.MethodVisitor[]{new MethodVisitor(this.cachedType, methodDescriptor, this.visitorHelper), new MethodLoCVisitor(methodDescriptor), new MethodComplexityVisitor(methodDescriptor)}));
    }

    private boolean isLambda(String name, int access) {
        return this.hasFlag(access, 4096) && this.hasFlag(access, 8) && name.startsWith(LAMBDA_METHOD);
    }

    private void setModifiers(int access, AccessModifierDescriptor descriptor) {
        VisibilityModifier visibility = this.getVisibility(access);
        descriptor.setVisibility(visibility.getValue());
        if (this.hasFlag(access, 4096)) {
            descriptor.setSynthetic(Boolean.TRUE);
        }
        if (this.hasFlag(access, 16)) {
            descriptor.setFinal(Boolean.TRUE);
        }
        if (this.hasFlag(access, 8)) {
            descriptor.setStatic(Boolean.TRUE);
        }
    }

    public void visitSource(String source, String debug) {
        this.cachedType.getTypeDescriptor().setSourceFileName(source);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String outerTypeName;
        String fullQualifiedName = this.cachedType.getTypeDescriptor().getFullQualifiedName();
        String innerTypeName = SignatureHelper.getObjectType(name);
        Object innerType = this.visitorHelper.resolveType(innerTypeName, this.cachedType).getTypeDescriptor();
        if (outerName != null && fullQualifiedName.equals(outerTypeName = SignatureHelper.getObjectType(outerName))) {
            this.cachedType.getTypeDescriptor().getDeclaredInnerClasses().add((TypeDescriptor)innerType);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        String outerTypeName = SignatureHelper.getObjectType(owner);
        TypeCache.CachedType cachedOuterType = this.visitorHelper.resolveType(outerTypeName, this.cachedType);
        ClassFileDescriptor innerType = this.cachedType.getTypeDescriptor();
        cachedOuterType.getTypeDescriptor().getDeclaredInnerClasses().add(innerType);
        if (name != null) {
            String methodSignature = SignatureHelper.getMethodSignature(name, desc);
            MethodDescriptor methodDescriptor = this.visitorHelper.getMethodDescriptor(cachedOuterType, methodSignature);
            methodDescriptor.getDeclaredInnerClasses().add(innerType);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.visitorHelper.addAnnotation(this.cachedType, this.cachedType.getTypeDescriptor(), SignatureHelper.getType(desc));
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitEnd() {
        this.visitorHelper.storeDependencies(this.cachedType);
        this.visitorHelper.getTypeVariableResolver().pop();
    }

    private boolean hasFlag(int value, int flag) {
        return (value & flag) == flag;
    }

    private VisibilityModifier getVisibility(int flags) {
        if (this.hasFlag(flags, 2)) {
            return VisibilityModifier.PRIVATE;
        }
        if (this.hasFlag(flags, 4)) {
            return VisibilityModifier.PROTECTED;
        }
        if (this.hasFlag(flags, 1)) {
            return VisibilityModifier.PUBLIC;
        }
        return VisibilityModifier.DEFAULT;
    }

    private Class<? extends ClassFileDescriptor> getJavaType(int flags) {
        if (this.hasFlag(flags, 8192)) {
            return AnnotationTypeDescriptor.class;
        }
        if (this.hasFlag(flags, 16384)) {
            return EnumTypeDescriptor.class;
        }
        if (this.hasFlag(flags, 512)) {
            return InterfaceTypeDescriptor.class;
        }
        return ClassTypeDescriptor.class;
    }
}

