/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodComplexityVisitor
extends MethodVisitor {
    private final MethodDescriptor methodDescriptor;
    private static final Set<Integer> OPCODES_IF = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 198, 199)));
    private Set<Label> whitelistLabels = new HashSet<Label>();
    private Map<Label, ExceptionHandler> exceptionHandlers = new HashMap<Label, ExceptionHandler>();
    private boolean skip = false;
    private int complexity;

    public MethodComplexityVisitor(MethodDescriptor methodDescriptor) {
        super(589824);
        this.methodDescriptor = methodDescriptor;
    }

    private void increment(int edges) {
        if (!this.skip) {
            this.complexity += edges;
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        ExceptionHandler exceptionHandler = ExceptionHandler.builder().start(start).end(end).handler(handler).type(type).build();
        this.exceptionHandlers.put(handler, exceptionHandler);
        if (!this.isSyntheticExceptionHandler(exceptionHandler)) {
            this.increment(1);
        }
    }

    public void visitLabel(Label label) {
        ExceptionHandler exceptionHandler = this.exceptionHandlers.get(label);
        if (exceptionHandler != null) {
            this.skip = this.isSyntheticExceptionHandler(exceptionHandler);
        }
        if (this.whitelistLabels.contains(label)) {
            this.skip = false;
        }
    }

    private boolean isSyntheticExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler.getType() == null || "java/lang/Throwable".equals(exceptionHandler.getType())) {
            return true;
        }
        return this.exceptionHandlers.get(exceptionHandler.getStart()) != null;
    }

    public void visitCode() {
        this.complexity = 1;
    }

    public void visitInsn(int opcode) {
        if (opcode == 191) {
            this.increment(1);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (!this.skip) {
            this.whitelistLabels.add(label);
        }
        if (OPCODES_IF.contains(opcode)) {
            this.increment(1);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.increment(labels.length + 1);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.increment(labels.length + 1);
    }

    public void visitEnd() {
        this.methodDescriptor.setCyclomaticComplexity(this.complexity);
    }

    private static class ExceptionHandler {
        private Label start;
        private Label end;
        private Label handler;
        private String type;

        ExceptionHandler(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }

        public static ExceptionHandlerBuilder builder() {
            return new ExceptionHandlerBuilder();
        }

        public Label getStart() {
            return this.start;
        }

        public Label getEnd() {
            return this.end;
        }

        public Label getHandler() {
            return this.handler;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "MethodComplexityVisitor.ExceptionHandler(start=" + this.getStart() + ", end=" + this.getEnd() + ", handler=" + this.getHandler() + ", type=" + this.getType() + ")";
        }

        public static class ExceptionHandlerBuilder {
            private Label start;
            private Label end;
            private Label handler;
            private String type;

            ExceptionHandlerBuilder() {
            }

            public ExceptionHandlerBuilder start(Label start) {
                this.start = start;
                return this;
            }

            public ExceptionHandlerBuilder end(Label end) {
                this.end = end;
                return this;
            }

            public ExceptionHandlerBuilder handler(Label handler) {
                this.handler = handler;
                return this;
            }

            public ExceptionHandlerBuilder type(String type) {
                this.type = type;
                return this;
            }

            public ExceptionHandler build() {
                return new ExceptionHandler(this.start, this.end, this.handler, this.type);
            }

            public String toString() {
                return "MethodComplexityVisitor.ExceptionHandler.ExceptionHandlerBuilder(start=" + this.start + ", end=" + this.end + ", handler=" + this.handler + ", type=" + this.type + ")";
            }
        }
    }
}

