/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodLoCVisitor
extends MethodVisitor {
    private final MethodDescriptor methodDescriptor;
    private Integer lineNumber = null;
    private Integer firstLineNumber = null;
    private Integer lastLineNumber = null;
    private Set<Integer> effectiveLines = new HashSet<Integer>();

    public MethodLoCVisitor(MethodDescriptor methodDescriptor) {
        super(589824);
        this.methodDescriptor = methodDescriptor;
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lineNumber == null) {
            this.firstLineNumber = line;
            this.lastLineNumber = line;
        } else {
            this.firstLineNumber = Math.min(line, this.firstLineNumber);
            this.lastLineNumber = Math.max(line, this.lastLineNumber);
        }
        this.lineNumber = line;
        this.effectiveLines.add(line);
    }

    public void visitEnd() {
        this.methodDescriptor.setFirstLineNumber(this.firstLineNumber);
        this.methodDescriptor.setLastLineNumber(this.lastLineNumber);
        if (!this.effectiveLines.isEmpty()) {
            this.methodDescriptor.setEffectiveLineCount(this.effectiveLines.size());
        }
    }
}

