/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.ServiceLoaderDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class ServiceLoaderFileScannerPlugin
extends AbstractScannerPlugin<FileResource, ServiceLoaderDescriptor> {
    private static final Pattern PATTERN = Pattern.compile("(.*/)?META-INF/services/(.*)");

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals(scope) && PATTERN.matcher(path).matches();
    }

    public ServiceLoaderDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Matcher matcher = PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new IOException("Cannot match path name: " + path);
        }
        String serviceInterface = matcher.group(2);
        ScannerContext context = scanner.getContext();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        ServiceLoaderDescriptor serviceLoaderDescriptor = (ServiceLoaderDescriptor)context.getStore().addDescriptorType((Descriptor)fileDescriptor, ServiceLoaderDescriptor.class);
        TypeDescriptor interfaceTypeDescriptor = this.getTypeDescriptor(serviceInterface, context);
        serviceLoaderDescriptor.setType(interfaceTypeDescriptor);
        try (InputStream stream = item.createStream();){
            String serviceImplementation;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((serviceImplementation = reader.readLine()) != null) {
                if (this.isEmptyOrComment(serviceImplementation)) continue;
                TypeDescriptor implementationTypeDescriptor = this.getTypeDescriptor(serviceImplementation, context);
                serviceLoaderDescriptor.getContains().add(implementationTypeDescriptor);
            }
        }
        return serviceLoaderDescriptor;
    }

    private boolean isEmptyOrComment(String line) {
        return StringUtils.isEmpty((CharSequence)line) || StringUtils.trimToEmpty((String)line).startsWith("#");
    }

    private TypeDescriptor getTypeDescriptor(String fqn, ScannerContext scannerContext) {
        TypeResolver typeResolver = (TypeResolver)scannerContext.peek(TypeResolver.class);
        return typeResolver.resolve(fqn, scannerContext).getTypeDescriptor();
    }
}

