/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.annotation.jQASuppress;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotatedDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaSuppressDescriptor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.objectweb.asm.AnnotationVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SuppressAnnotationVisitor
extends AnnotationVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuppressAnnotationVisitor.class);
    private final JavaSuppressDescriptor suppressDescriptor;
    private String currentAttribute;
    private final List<String> suppressIds = new ArrayList<String>();
    private String suppressColumn;
    private LocalDate suppressUntil;
    private String suppressReason;

    public SuppressAnnotationVisitor(AnnotatedDescriptor annotatedDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.suppressDescriptor = (JavaSuppressDescriptor)visitorHelper.getStore().addDescriptorType((Descriptor)annotatedDescriptor, JavaSuppressDescriptor.class);
    }

    public void visit(String name, Object value) {
        if (name != null) {
            switch (name) {
                case "column": {
                    this.suppressColumn = value.toString();
                    break;
                }
                case "reason": {
                    this.suppressReason = value.toString();
                    break;
                }
                case "until": {
                    try {
                        this.suppressUntil = LocalDate.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalArgumentException("Wrong jQASuppress until date format, must be of format 'yyyy-MM-dd'.", e);
                    }
                }
                default: {
                    log.warn("Unknown attribute '{}' for {}", (Object)name, (Object)jQASuppress.class.getName());
                    break;
                }
            }
        } else {
            switch (this.currentAttribute) {
                case "value": {
                    this.suppressIds.add(value.toString());
                    break;
                }
                default: {
                    log.warn("Unknown attribute '{}' for {}", (Object)this.currentAttribute, (Object)jQASuppress.class.getName());
                }
            }
        }
    }

    public AnnotationVisitor visitArray(String name) {
        this.currentAttribute = name;
        return this;
    }

    public void visitEnd() {
        this.suppressDescriptor.setSuppressIds(this.suppressIds.toArray(new String[0]));
        this.suppressDescriptor.setSuppressColumn(this.suppressColumn);
        this.suppressDescriptor.setSuppressUntil(this.suppressUntil);
        this.suppressDescriptor.setSuppressReason(this.suppressReason);
    }
}

