/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.json.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.json.api.model.JSONArrayDescriptor;
import com.buschmais.jqassistant.plugin.json.api.model.JSONFileDescriptor;
import com.buschmais.jqassistant.plugin.json.api.model.JSONKeyDescriptor;
import com.buschmais.jqassistant.plugin.json.api.model.JSONObjectDescriptor;
import com.buschmais.jqassistant.plugin.json.api.model.JSONScalarValueDescriptor;
import com.buschmais.jqassistant.plugin.json.api.model.JSONValueDescriptor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class JSONFileScannerPlugin
extends AbstractScannerPlugin<FileResource, JSONFileDescriptor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JSONFileScannerPlugin.class);
    public static final String PROPERTY_INCLUDE = "json.file.include";
    public static final String PROPERTY_EXCLUDE = "json.file.exclude";
    private ObjectMapper objectMapper;
    private FilePatternMatcher filePatternMatcher;

    public void initialize() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        this.objectMapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
    }

    protected void configure() {
        String inclusionPattern = this.getStringProperty(PROPERTY_INCLUDE, "*.json");
        String exclusionPattern = this.getStringProperty(PROPERTY_EXCLUDE, null);
        this.filePatternMatcher = FilePatternMatcher.builder().include(inclusionPattern).exclude(exclusionPattern).build();
    }

    public boolean accepts(FileResource file, String path, Scope scope) {
        return this.filePatternMatcher.accepts(path);
    }

    public JSONFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        Store store = context.getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        JSONFileDescriptor jsonFileDescriptor = (JSONFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, JSONFileDescriptor.class);
        try (InputStream inputStream = item.createStream();){
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.IGNORE);
            InputStreamReader reader = new InputStreamReader(inputStream, charsetDecoder);
            JsonNode jsonNode = this.objectMapper.readTree((Reader)reader);
            JSONValueDescriptor valueDescriptor = this.toDescriptor(jsonNode, store);
            if (valueDescriptor != null) {
                jsonFileDescriptor.setValue(valueDescriptor);
                jsonFileDescriptor.setValid(true);
            } else {
                jsonFileDescriptor.setValid(false);
            }
        }
        catch (JsonProcessingException e) {
            jsonFileDescriptor.setValid(false);
        }
        return jsonFileDescriptor;
    }

    private JSONValueDescriptor toDescriptor(JsonNode jsonNode, Store store) {
        switch (jsonNode.getNodeType()) {
            case BOOLEAN: {
                return JSONFileScannerPlugin.toScalarValue(jsonNode.booleanValue(), store);
            }
            case STRING: {
                return JSONFileScannerPlugin.toScalarValue(jsonNode.textValue(), store);
            }
            case NUMBER: {
                return JSONFileScannerPlugin.numberToScalarValue(jsonNode.numberValue(), store);
            }
            case NULL: {
                return JSONFileScannerPlugin.numberToScalarValue(null, store);
            }
            case OBJECT: {
                JSONObjectDescriptor objectDescriptor = (JSONObjectDescriptor)store.create(JSONObjectDescriptor.class);
                for (Map.Entry property : jsonNode.properties()) {
                    JSONKeyDescriptor keyDescriptor = (JSONKeyDescriptor)store.create(JSONKeyDescriptor.class);
                    keyDescriptor.setName((String)property.getKey());
                    JSONValueDescriptor valueDescriptor = this.toDescriptor((JsonNode)property.getValue(), store);
                    keyDescriptor.setValue(valueDescriptor);
                    objectDescriptor.getKeys().add(keyDescriptor);
                }
                return objectDescriptor;
            }
            case ARRAY: {
                JSONArrayDescriptor arrayDescriptor = (JSONArrayDescriptor)store.create(JSONArrayDescriptor.class);
                Iterator elements = jsonNode.elements();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    JSONValueDescriptor valueDescriptor = this.toDescriptor(element, store);
                    if (valueDescriptor == null) continue;
                    arrayDescriptor.getValues().add(valueDescriptor);
                }
                return arrayDescriptor;
            }
            case MISSING: {
                return null;
            }
        }
        log.info("Encountered unknown JSON node: {}", (Object)jsonNode);
        return null;
    }

    private static JSONScalarValueDescriptor numberToScalarValue(Number value, Store store) {
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            return JSONFileScannerPlugin.toScalarValue(value.toString(), store);
        }
        return JSONFileScannerPlugin.toScalarValue(value, store);
    }

    private static JSONScalarValueDescriptor toScalarValue(Object value, Store store) {
        JSONScalarValueDescriptor valueDescriptor = (JSONScalarValueDescriptor)store.create(JSONScalarValueDescriptor.class);
        valueDescriptor.setValue(value);
        return valueDescriptor;
    }
}

