/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.json.impl.report;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Rule;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JSONReportPlugin
implements ReportPlugin {
    private static final String REPORT_TYPE = "json";
    private ObjectMapper objectMapper;
    private ReportContext reportContext;

    public void initialize() {
        this.objectMapper = new ObjectMapper();
    }

    public void configure(ReportContext reportContext, Map<String, Object> properties) {
        this.reportContext = reportContext;
    }

    public void setResult(Result<? extends ExecutableRule> result) throws ReportException {
        List columnNames = result.getColumnNames();
        if (columnNames != null) {
            this.writeReport(result, columnNames);
        }
    }

    private void writeReport(Result<? extends ExecutableRule> result, List<String> columnNames) throws ReportException {
        String fileName = ReportHelper.escapeRuleId((Rule)result.getRule()) + ".json";
        File reportDirectory = this.reportContext.getReportDirectory(REPORT_TYPE);
        File file = new File(reportDirectory, fileName);
        Optional columnName = columnNames.size() == 1 ? Optional.of(columnNames.get(0)) : Optional.empty();
        Stream<Object> stream = result.getRows().stream().map(row -> JSONReportPlugin.getRow(row.getColumns(), columnName));
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, stream.iterator());
        }
        catch (IOException e) {
            throw new ReportException("Cannot write JSON report.", (Throwable)e);
        }
        try {
            this.reportContext.addReport("JSON", result.getRule(), ReportContext.ReportType.LINK, file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new ReportException("Cannot get URL for file " + String.valueOf(file), (Throwable)e);
        }
    }

    private static Object getRow(Map<String, Column<?>> columns, Optional<String> columName) {
        return columName.map(s -> ((Column)columns.get(s)).getValue()).orElseGet(() -> columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, k -> ((Column)k.getValue()).getValue())));
    }
}

