/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.report;

import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.api.model.Language;
import com.buschmais.jqassistant.core.report.api.model.LanguageElement;
import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.report.FileSourceHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;

@Language
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Maven {
    public MavenLanguageElement value();

    public static enum MavenLanguageElement implements LanguageElement
    {
        PomXmlFile{

            public SourceProvider<MavenPomXmlDescriptor> getSourceProvider() {
                return new SourceProvider<MavenPomXmlDescriptor>(){

                    public String getName(MavenPomXmlDescriptor descriptor) {
                        String groupId = descriptor.getGroupId() != null ? descriptor.getGroupId() : descriptor.getParent().getGroup();
                        return groupId + ":" + descriptor.getArtifactId();
                    }

                    public Optional<FileLocation> getSourceLocation(MavenPomXmlDescriptor descriptor) {
                        return FileSourceHelper.getSourceLocation((FileDescriptor)descriptor, Optional.empty(), Optional.empty());
                    }
                };
            }
        };


        public String getLanguage() {
            return "Maven";
        }
    }
}

