/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.report;

import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.api.model.Language;
import com.buschmais.jqassistant.core.report.api.model.LanguageElement;
import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.report.FileSourceHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;

@Language
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Maven {
    public MavenLanguageElement value();

    public static enum MavenLanguageElement implements LanguageElement
    {
        Pom{

            public SourceProvider<MavenPomDescriptor> getSourceProvider() {
                return new SourceProvider<MavenPomDescriptor>(){

                    public String getName(MavenPomDescriptor descriptor) {
                        String groupId = descriptor.getGroupId() != null ? descriptor.getGroupId() : descriptor.getParent().getGroup();
                        return groupId + ":" + descriptor.getArtifactId();
                    }

                    public Optional<FileLocation> getSourceLocation(MavenPomDescriptor descriptor) {
                        if (descriptor instanceof FileDescriptor) {
                            return FileSourceHelper.getSourceLocation((FileDescriptor)((FileDescriptor)descriptor), Optional.empty(), Optional.empty());
                        }
                        return Optional.empty();
                    }
                };
            }
        };


        public String getLanguage() {
            return "Maven";
        }
    }
}

