/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDocumentDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLMapDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLScalarDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLSequenceDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.Callback;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerator;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.NodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.DocumentNode;

public class DocumentNodeProcessor
implements NodeProcessor<DocumentNode, YMLDocumentDescriptor> {
    private final Store store;
    private final GraphGenerator generator;

    public DocumentNodeProcessor(Store store, GraphGenerator generator) {
        this.store = store;
        this.generator = generator;
    }

    @Override
    public void process(DocumentNode node, Callback<YMLDocumentDescriptor> callback, GraphGenerator.Mode mode) {
        YMLDocumentDescriptor documentDescriptor = (YMLDocumentDescriptor)this.store.create(YMLDocumentDescriptor.class);
        Callback<YMLSequenceDescriptor> callbackForSeq = descriptor -> documentDescriptor.getSequences().add((YMLSequenceDescriptor)descriptor);
        Callback<YMLMapDescriptor> callbackForMaps = descriptor -> documentDescriptor.getMaps().add((YMLMapDescriptor)descriptor);
        Callback<YMLScalarDescriptor> callbackForScalars = descriptor -> documentDescriptor.getScalars().add((YMLScalarDescriptor)descriptor);
        node.getSequences().forEach(sequenceNode -> this.generator.traverse((AbstractBaseNode)sequenceNode, (Callback<? extends YMLDescriptor>)callbackForSeq, mode));
        node.getMaps().forEach(mapNode -> this.generator.traverse((AbstractBaseNode)mapNode, (Callback<? extends YMLDescriptor>)callbackForMaps, mode));
        node.getScalars().forEach(scalarNode -> this.generator.traverse((AbstractBaseNode)scalarNode, (Callback<? extends YMLDescriptor>)callbackForScalars, mode));
        callback.created(documentDescriptor);
    }

    @Override
    public boolean accepts(AbstractBaseNode node) {
        return node.getClass().isAssignableFrom(DocumentNode.class);
    }
}

