/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLAliasDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLComplexKeyDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLComplexKeyValue;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLMapDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLSimpleKeyDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLValueDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AliasLinker;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AnchorHandler;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.Callback;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.GraphGenerator;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.NodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.BaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ComplexKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.MapNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ScalarNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.SimpleKeyNode;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.stream.Collectors;

class MapNodeProcessor
implements NodeProcessor<MapNode, YMLMapDescriptor> {
    private final Store store;
    private final GraphGenerator generator;
    private final AnchorHandler anchorHandler;
    private final AliasLinker aliasLinker;

    public MapNodeProcessor(Store store, GraphGenerator generator, AnchorHandler anchorHandler, AliasLinker aliasLinker) {
        this.store = store;
        this.generator = generator;
        this.anchorHandler = anchorHandler;
        this.aliasLinker = aliasLinker;
    }

    @Override
    public void process(MapNode node, Callback<YMLMapDescriptor> callback, GraphGenerator.Mode mode) {
        YMLMapDescriptor mapDescriptor = (YMLMapDescriptor)this.store.create(YMLMapDescriptor.class);
        node.getIndex().ifPresent(mapDescriptor::setIndex);
        this.anchorHandler.handleAnchor(node, mapDescriptor, mode);
        TreeSet<AbstractTask> tasks = new TreeSet<AbstractTask>(Comparator.comparingInt(AbstractTask::getTokenIndex));
        node.getSimpleKeys().stream().map(keyNode -> new SimpleKeyTask((SimpleKeyNode)keyNode, mapDescriptor, mode)).collect(Collectors.toCollection(() -> tasks));
        node.getComplexKeys().stream().map(keyNode -> new ComplexKeyTask((ComplexKeyNode)keyNode, mapDescriptor, mode)).collect(Collectors.toCollection(() -> tasks));
        node.getAliasKeys().stream().map(keyNode -> new AliasKeyTask((AliasKeyNode)keyNode, mapDescriptor, mode)).collect(Collectors.toCollection(() -> tasks));
        tasks.forEach(AbstractTask::run);
        callback.created(mapDescriptor);
    }

    @Override
    public boolean accepts(AbstractBaseNode node) {
        return node.getClass().isAssignableFrom(MapNode.class);
    }

    private class AliasKeyTask
    extends AbstractTask {
        private final YMLMapDescriptor mapDescriptor;
        private final AliasKeyNode aliasKeyNode;
        private final GraphGenerator.Mode mode;

        public AliasKeyTask(AliasKeyNode node, YMLMapDescriptor mapDescriptor, GraphGenerator.Mode mode) {
            this.aliasKeyNode = node;
            this.mapDescriptor = mapDescriptor;
            this.mode = mode;
        }

        @Override
        int getTokenIndex() {
            return this.aliasKeyNode.getTokenIndex();
        }

        @Override
        void run() {
            if (this.aliasKeyNode.getKey() instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)this.aliasKeyNode.getKey();
                YMLSimpleKeyDescriptor simpleKeyDescriptor = (YMLSimpleKeyDescriptor)MapNodeProcessor.this.store.create(YMLSimpleKeyDescriptor.class);
                simpleKeyDescriptor.setName(scalarNode.getScalarValue());
                MapNodeProcessor.this.store.addDescriptorType((Descriptor)simpleKeyDescriptor, YMLAliasDescriptor.class);
                this.mapDescriptor.getKeys().add(simpleKeyDescriptor);
                MapNodeProcessor.this.aliasLinker.linkToAnchor(this.aliasKeyNode, simpleKeyDescriptor);
                BaseNode<?> value = this.aliasKeyNode.getValue();
                Callback<YMLDescriptor> callback = simpleKeyDescriptor::setValue;
                if (value instanceof AliasNode) {
                    MapNodeProcessor.this.generator.traverse(value, callback, this.mode);
                } else {
                    MapNodeProcessor.this.generator.traverse(this.aliasKeyNode.getValue(), callback, this.mode);
                }
            } else {
                String message = "Key of alias key node is not a scalar node";
                throw new IllegalStateException(message);
            }
        }
    }

    private class ComplexKeyTask
    extends AbstractTask {
        private final ComplexKeyNode keyNode;
        private final YMLMapDescriptor mapDescriptor;
        private final GraphGenerator.Mode mode;

        public ComplexKeyTask(ComplexKeyNode node, YMLMapDescriptor mapDescriptor, GraphGenerator.Mode mode) {
            this.keyNode = node;
            this.mapDescriptor = mapDescriptor;
            this.mode = mode;
        }

        @Override
        void run() {
            YMLComplexKeyDescriptor keyDescriptor = (YMLComplexKeyDescriptor)MapNodeProcessor.this.store.create(YMLComplexKeyDescriptor.class);
            this.mapDescriptor.getComplexKeys().add(keyDescriptor);
            Callback<YMLDescriptor> addComplexKeyDescriptorCallback = key -> {
                keyDescriptor.setKey(key);
                MapNodeProcessor.this.store.addDescriptorType((Descriptor)keyDescriptor.getKey(), YMLComplexKeyValue.class);
            };
            Callback<YMLDescriptor> addValueKeyDescriptorCallback = descriptor -> {
                keyDescriptor.setValue(descriptor);
                MapNodeProcessor.this.store.addDescriptorType((Descriptor)keyDescriptor.getValue(), YMLValueDescriptor.class);
            };
            MapNodeProcessor.this.generator.traverse(this.keyNode.getKeyNode(), addComplexKeyDescriptorCallback, this.mode);
            MapNodeProcessor.this.anchorHandler.handleAnchor(this.keyNode.getKeyNode(), keyDescriptor.getKey(), this.mode);
            MapNodeProcessor.this.generator.traverse(this.keyNode.getValue(), addValueKeyDescriptorCallback, this.mode);
        }

        @Override
        int getTokenIndex() {
            return this.keyNode.getTokenIndex();
        }
    }

    private class SimpleKeyTask
    extends AbstractTask {
        private final SimpleKeyNode keyNode;
        private final YMLMapDescriptor mapDescriptor;
        private final GraphGenerator.Mode mode;

        public SimpleKeyTask(SimpleKeyNode node, YMLMapDescriptor mapDescriptor, GraphGenerator.Mode mode) {
            this.keyNode = node;
            this.mapDescriptor = mapDescriptor;
            this.mode = mode;
        }

        @Override
        int getTokenIndex() {
            return this.keyNode.getTokenIndex();
        }

        @Override
        void run() {
            YMLSimpleKeyDescriptor keyDescriptor = (YMLSimpleKeyDescriptor)MapNodeProcessor.this.store.create(YMLSimpleKeyDescriptor.class);
            keyDescriptor.setName(this.keyNode.getKeyName());
            this.mapDescriptor.getKeys().add(keyDescriptor);
            MapNodeProcessor.this.anchorHandler.handleAnchor(this.keyNode, keyDescriptor, this.mode);
            Callback<YMLDescriptor> addValueDescriptorCallback = descriptor -> {
                MapNodeProcessor.this.store.addDescriptorType((Descriptor)descriptor, YMLValueDescriptor.class);
                keyDescriptor.setValue(descriptor);
            };
            if (this.keyNode.getValue().getClass().isAssignableFrom(AliasNode.class)) {
                AliasNode aliasNode = (AliasNode)this.keyNode.getValue();
                Callback<YMLDescriptor> createReferenceCallback = descriptor -> {
                    addValueDescriptorCallback.created(descriptor);
                    MapNodeProcessor.this.aliasLinker.linkToAnchor(aliasNode, descriptor);
                };
                MapNodeProcessor.this.generator.traverse(aliasNode, createReferenceCallback, GraphGenerator.Mode.REFERENCE);
            } else {
                BaseNode<?> valueNode = this.keyNode.getValue();
                MapNodeProcessor.this.generator.traverse(valueNode, addValueDescriptorCallback, this.mode);
            }
            MapNodeProcessor.this.store.addDescriptorType((Descriptor)keyDescriptor.getValue(), YMLValueDescriptor.class);
        }
    }

    private static abstract class AbstractTask {
        private AbstractTask() {
        }

        abstract int getTokenIndex();

        abstract void run();
    }
}

