/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing;

import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.DocumentNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.MapNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.PositionalContext;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.SequenceNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.StreamNode;

class ParsingContextType<D extends AbstractBaseNode> {
    private D node;
    private Type type;
    private PositionalContext positionalContext;
    boolean isKeyForValue = false;

    private ParsingContextType(Type contextType, D contextNode, PositionalContext context) {
        this.type = contextType;
        this.node = contextNode;
        this.positionalContext = context;
    }

    static ParsingContextType<DocumentNode> ofInDocument(DocumentNode descriptor) {
        return new ParsingContextType<DocumentNode>(Type.IN_DOCUMENT, descriptor, PositionalContext.noPositionalContext());
    }

    static ParsingContextType<MapNode> ofInMap(MapNode descriptor) {
        return new ParsingContextType<MapNode>(Type.IN_MAP, descriptor, PositionalContext.noPositionalContext());
    }

    static ParsingContextType<SequenceNode> ofInSequence(SequenceNode descriptor) {
        return new ParsingContextType<SequenceNode>(Type.IN_SEQUENCE, descriptor, new PositionalContext());
    }

    static ParsingContextType<StreamNode> ofInStream(StreamNode node) {
        return new ParsingContextType<StreamNode>(Type.IN_STREAM, node, PositionalContext.noPositionalContext());
    }

    static <D extends AbstractBaseNode> ParsingContextType<D> ofInKey(D node) {
        return new ParsingContextType<D>(Type.IN_KEY, node, PositionalContext.noPositionalContext());
    }

    static ParsingContextType<AliasKeyNode> ofInAliasKey(AliasKeyNode node) {
        return new ParsingContextType<AliasKeyNode>(Type.IN_ALIAS_KEY, node, PositionalContext.noPositionalContext());
    }

    static <D extends AbstractBaseNode> ParsingContextType<D> ofInComplexKey(D node) {
        return new ParsingContextType<D>(Type.IN_COMPLEX_KEY, node, PositionalContext.noPositionalContext());
    }

    Type getType() {
        return this.type;
    }

    public boolean isKeyForValue() {
        return this.isKeyForValue;
    }

    public void setKeyForValue(boolean value) {
        this.isKeyForValue = value;
    }

    public PositionalContext getPositionalContext() {
        return this.positionalContext;
    }

    public D getNode() {
        return this.node;
    }

    public String toString() {
        return "ContextType{type=" + String.valueOf((Object)this.type) + "}";
    }

    static enum Type {
        IN_ALIAS_KEY,
        IN_COMPLEX_KEY,
        IN_DOCUMENT,
        IN_KEY,
        IN_MAP,
        IN_SEQUENCE,
        IN_STREAM;

    }
}

