/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.api;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.embedded.api.DatabaseManagementServiceFactory;
import com.buschmais.xo.neo4j.embedded.api.InstrumentationProvider;
import com.buschmais.xo.neo4j.embedded.api.Slf4jLogProvider;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.LogProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedDatabaseManagementServiceFactory
implements DatabaseManagementServiceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEmbeddedDatabaseManagementServiceFactory.class);
    private static final String PLUGIN_DIRECTORY = "plugins";

    @Override
    public final DatabaseManagementService createDatabaseManagementService(URI uri, Config config, Properties properties) {
        File directory = new File(URLDecoder.decode(uri.getSchemeSpecificPart(), StandardCharsets.UTF_8)).getAbsoluteFile();
        File pluginDirectory = AbstractEmbeddedDatabaseManagementServiceFactory.initializePlugins(directory, properties);
        Map<Setting<?>, Object> settings = this.toSettings(config);
        settings.put(GraphDatabaseSettings.plugin_dir, pluginDirectory.toPath());
        settings.put(GraphDatabaseInternalSettings.track_cursor_close, false);
        return this.getDatabaseManagementService(directory.toPath(), settings, Slf4jLogProvider.INSTANCE);
    }

    private Map<Setting<?>, Object> toSettings(Config config) {
        HashMap settings = new HashMap();
        for (Setting setting : config.getDeclaredSettings().values()) {
            if (!config.isExplicitlySet(setting)) continue;
            settings.put(setting, config.get(setting));
        }
        return settings;
    }

    protected abstract DatabaseManagementService getDatabaseManagementService(Path var1, Map<Setting<?>, Object> var2, LogProvider var3);

    private static File initializePlugins(File storeDir, Properties properties) {
        File pluginDirectory = new File(storeDir, PLUGIN_DIRECTORY);
        AbstractEmbeddedDatabaseManagementServiceFactory.copyPlugins(pluginDirectory, properties);
        Set<Path> pluginPaths = AbstractEmbeddedDatabaseManagementServiceFactory.listPlugins(pluginDirectory);
        AbstractEmbeddedDatabaseManagementServiceFactory.getClasspathAppender().accept(pluginPaths);
        return pluginDirectory;
    }

    private static void copyPlugins(File pluginDirectory, Properties properties) {
        String plugins = properties.getProperty("xo.neo4j.embedded.plugins");
        if (StringUtils.isNotEmpty((CharSequence)plugins)) {
            if (!pluginDirectory.exists() && !pluginDirectory.mkdirs()) {
                log.warn("Cannot create embedded Neo4j database plugin directory '{}'.", (Object)pluginDirectory.getAbsolutePath());
            }
            for (String plugin : Splitter.on((String)",").trimResults().splitToList((CharSequence)plugins)) {
                File sourceFile = new File(plugin);
                File destinationFile = new File(pluginDirectory, sourceFile.getName());
                if (destinationFile.exists()) continue;
                try {
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                }
                catch (IOException e) {
                    throw new XOException("Cannot copy plugin " + String.valueOf(sourceFile) + " to " + String.valueOf(destinationFile), (Throwable)e);
                }
            }
        }
    }

    private static Set<Path> listPlugins(File pluginDirectory) {
        HashSet<Path> fileSet = new HashSet<Path>();
        if (pluginDirectory.exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginDirectory.toPath());){
                for (Path path : stream) {
                    if (Files.isDirectory(path, new LinkOption[0])) continue;
                    fileSet.add(path);
                }
            }
            catch (IOException e) {
                throw new XOException("Cannot list plugin directory " + String.valueOf(pluginDirectory), (Throwable)e);
            }
        }
        return fileSet;
    }

    private static Consumer<Set<Path>> getClasspathAppender() {
        ClassLoader neo4jClassLoader = GraphDatabaseSettings.class.getClassLoader();
        log.debug("Using Neo4j classloader {}", (Object)neo4jClassLoader);
        if (neo4jClassLoader instanceof URLClassLoader) {
            return AbstractEmbeddedDatabaseManagementServiceFactory.getURLClassLoaderAppender((URLClassLoader)neo4jClassLoader);
        }
        return AbstractEmbeddedDatabaseManagementServiceFactory.getInstrumentationAppender();
    }

    private static Consumer<Set<Path>> getURLClassLoaderAppender(URLClassLoader classLoader) {
        Method method;
        try {
            method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException e) {
            throw new XOException("Cannot use URLClassLoader to extend classpath.", (Throwable)e);
        }
        method.setAccessible(true);
        Set<URL> existingUrls = Set.of(classLoader.getURLs());
        return paths -> {
            for (Path path : paths) {
                URL url;
                try {
                    url = path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
                if (existingUrls.contains(url)) continue;
                try {
                    method.invoke((Object)classLoader, url);
                }
                catch (ReflectiveOperationException e) {
                    throw new XOException("Cannot add URL to classloader.", (Throwable)e);
                }
            }
        };
    }

    private static Consumer<Set<Path>> getInstrumentationAppender() {
        return paths -> InstrumentationProvider.INSTANCE.getInstrumentation().ifPresentOrElse(instrumentation -> {
            for (Path path : paths) {
                JarFile jarFile;
                try {
                    jarFile = new JarFile(path.toFile());
                }
                catch (IOException e) {
                    throw new XOException("Cannot create JAR from file " + String.valueOf(path.toAbsolutePath()), (Throwable)e);
                }
                instrumentation.appendToSystemClassLoaderSearch(jarFile);
            }
        }, () -> log.warn("Runtime instrumentation is not available, Neo4j plugins might not work."));
    }
}

