package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.model;

import com.cebpubservice.remotebidevaluation.CommonRequest;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.constant.ComponentExpertLibraryShareExtractConstant;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param.PushExpertNoExtractStatusParamDTO;
import com.cebpubservice.remotebidevaluation.utils.CebsConstant;

/**
 * 推送专家未抽取状态
 *
 * @author 韦笑迎
 * ===============================
 * Date：2025/1/22
 * Time：22:42
 * ================================
 */
public class PushExpertNoExtractStatusRequest  extends CommonRequest<PushExpertNoExtractStatusParamDTO> {

    public PushExpertNoExtractStatusRequest(PushExpertNoExtractStatusParamDTO dto) {
        // 设置请求的基础URL
        super(ComponentExpertLibraryShareExtractConstant.API_PATH);
        // 设置请求的头部参数，用于业务编码
        this.putHeadParameter(CebsConstant.SERVICE_CODE, ComponentExpertLibraryShareExtractConstant.EXPERT_LIBRARY_SHARE_EXTRACT_SERVICE_NAME);
        // 设置请求的头部参数，用于功能编码
        this.putHeadParameter(CebsConstant.FEATURE_CODE, ComponentExpertLibraryShareExtractConstant.FEATURE_CODE_PENES);
        // 设置请求的头部参数，用于标识版本号
        this.putHeadParameter(CebsConstant.VERSION_CODE, ComponentExpertLibraryShareExtractConstant.V_1_0_0);

        // 设置请求的数据部分，即查询参数DTO对象
        this.data = dto;
    }

}
