package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param;

import java.util.Date;

/**
 * 专家预查询
 *
 * @author 柏晨瑶
 * ===============================
 * Date：2025/2/20
 * Time：20:49
 * ================================
 */
public class PreQueryExpertParamDTO {

    /**
     * 评标专家库标识码
     */
    private String expertLibraryCode;

    /**
     * 抽取专业大类编码（参考数据规范4.4.2 建设工程项目专业分类编码，一级编码）
     */
    private String majorCategoryCode;

    /**
     * 抽取专业小类编码（参考数据规范4.4.2 建设工程项目专业分类编码，子级编码，可设置多个专业小类，多个专业小类之间逗号,隔开）
     */
    private String majorSubcategoryCode;

    /**
     * 抽取人数
     */
    private Integer expertNum;

    /**
     * 预计评标开始时间
     */
    private Date estimateEvaluationStartTime;

    /**
     * 专家评标交易中心场所编码
     */
    private String tradingCenterCode;

    /**
     * 专家评标交易中心场所名称
     */
    private String tradingCenterName;

    /**
     * 抽取地区编码
     * @return
     */
    private String placeRegionCode;

    public String getExpertLibraryCode() {
        return expertLibraryCode;
    }

    public void setExpertLibraryCode(String expertLibraryCode) {
        this.expertLibraryCode = expertLibraryCode;
    }

    public String getMajorCategoryCode() {
        return majorCategoryCode;
    }

    public void setMajorCategoryCode(String majorCategoryCode) {
        this.majorCategoryCode = majorCategoryCode;
    }

    public String getTradingCenterCode() {
        return tradingCenterCode;
    }

    public void setTradingCenterCode(String tradingCenterCode) {
        this.tradingCenterCode = tradingCenterCode;
    }

    public String getTradingCenterName() {
        return tradingCenterName;
    }

    public void setTradingCenterName(String tradingCenterName) {
        this.tradingCenterName = tradingCenterName;
    }

    public String getMajorSubcategoryCode() {
        return majorSubcategoryCode;
    }

    public void setMajorSubcategoryCode(String majorSubcategoryCode) {
        this.majorSubcategoryCode = majorSubcategoryCode;
    }

    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }

    public Date getEstimateEvaluationStartTime() {
        return estimateEvaluationStartTime;
    }

    public void setEstimateEvaluationStartTime(Date estimateEvaluationStartTime) {
        this.estimateEvaluationStartTime = estimateEvaluationStartTime;
    }

    public String getPlaceRegionCode() {
        return placeRegionCode;
    }

    public void setPlaceRegionCode(String placeRegionCode) {
        this.placeRegionCode = placeRegionCode;
    }
}
