package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.result;

import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.model.*;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param.*;
import com.cebpubservice.remotebidevaluation.exceptions.ClientException;

/**
 * 专家库共享抽取
 * @author 柏晨瑶
 * ===============================
 * Date：2025/1/14
 * Time：17:53
 * ================================
 */
public class ExpertLibraryShareExtract {

    /**
     * 推送专家抽取申请信息
     * @return 推送专家抽取申请信息结果
     */
    public static boolean pushExpertExtractApply(PushExpertExtractApplyParamDTO pushExpertExtractResultParamDTO) {
        PushExpertExtractApplyRequest pushExpertExtractApplyRequest = new PushExpertExtractApplyRequest(pushExpertExtractResultParamDTO);
        try {
            // 调用共享目录服务组件接口推送专家抽取申请信息
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(pushExpertExtractApplyRequest, Boolean.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 获取专家抽取终端异地抽取页面访问地址
     * @return 获取专家抽取终端异地抽取页面访问地址结果
     */
    public static GetExtractTerminalUrlResult getExtractTerminalUrl(GetExtractTerminalUrlParamDTO getExtractTerminalUrlParamDTO) {
        GetExtractTerminalUrlRequest getExtractTerminalUrlRequest = new GetExtractTerminalUrlRequest(getExtractTerminalUrlParamDTO);
        try {
            // 调用共享目录服务组件接口推送专家请假信息
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(getExtractTerminalUrlRequest, GetExtractTerminalUrlResult.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 推送专家抽取取消信息
     * @return 推推送专家抽取取消信息结果
     */
    public static boolean pushExpertExtractCancelInfo(PushExpertExtractCancelInfoParamDTO pushExpertExtractCancelInfoParamDTO) {
        PushExpertExtractCancelInfoRequest pushExpertExtractCancelInfoRequest = new PushExpertExtractCancelInfoRequest(pushExpertExtractCancelInfoParamDTO);
        try {
            // 调用共享目录服务组件接口推送专家抽取取消信息
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(pushExpertExtractCancelInfoRequest, Boolean.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 推送专家抽取中状态
     *
     * @return 推送专家抽取中状态结果
     */
    public static boolean pushExpertExtractStatus(PushExpertExtractStatusParamDTO pushExpertExtractStatusParamDTO) {
        PushExpertExtractStatusRequest pushExpertExtractStatusRequest = new PushExpertExtractStatusRequest(pushExpertExtractStatusParamDTO);
        try {
            // 调用共享目录服务组件接口推送专家抽取中状态
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(pushExpertExtractStatusRequest, Boolean.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 推送专家未抽取状态
     *
     * @return 推送专家未抽取状态结果
     */
    public static boolean pushExpertNoExtractStatus(PushExpertNoExtractStatusParamDTO pushExpertNoExtractStatusParamDTO) {
        PushExpertNoExtractStatusRequest pushExpertNoExtractStatusRequest = new PushExpertNoExtractStatusRequest(pushExpertNoExtractStatusParamDTO);
        try {
            // 调用共享目录服务组件接口推送专家未抽取状态
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(pushExpertNoExtractStatusRequest, Boolean.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 专家预查询
     *
     * @return 专家预查询结果
     */
    public static PreQueryExpertResult preQueryExpert(PreQueryExpertParamDTO preQueryExpertParamDTO) {
        PreQueryExpertRequest preQueryExpertRequest = new PreQueryExpertRequest(preQueryExpertParamDTO);
        try {
            // 调用共享目录服务组件接口专家预查询
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(preQueryExpertRequest, PreQueryExpertResult.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 查询抽取专业
     *
     * @return 查询抽取专业结果
     */
    public static QueryExtractMajorResult queryExtractMajor(QueryExtractMajorParamDTO queryExtractMajorParamDTO) {
        QueryExtractMajorRequest queryExtractMajorRequest = new QueryExtractMajorRequest(queryExtractMajorParamDTO);
        try {
            // 调用共享目录服务组件接口查询抽取专业
            return ComponentExpertLibraryShareExtractSingleton.getInstance().getResult(queryExtractMajorRequest, QueryExtractMajorResult.class);
        } catch (ClientException e) {
            e.printStackTrace();
            return null;
        }
    }
}
