/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.cloudhopper.smpp.type.SmppConnectionConfiguration;

public class SmppSessionConfiguration
extends SmppConnectionConfiguration {
    private String name;
    private int windowSize = 1;
    private SmppBindType type;
    private String systemId;
    private String password;
    private String systemType;
    private byte interfaceVersion;
    private Address addressRange;
    private long bindTimeout;
    private LoggingOptions loggingOptions;
    private long windowWaitTimeout;
    private long requestExpiryTimeout;
    private long windowMonitorInterval;
    private boolean countersEnabled;

    public SmppSessionConfiguration() {
        this(SmppBindType.TRANSCEIVER, null, null, null);
    }

    public SmppSessionConfiguration(SmppBindType type, String systemId, String password) {
        this(type, systemId, password, null);
    }

    public SmppSessionConfiguration(SmppBindType type, String systemId, String password, String systemType) {
        this.type = type;
        this.systemId = systemId;
        this.password = password;
        this.systemType = systemType;
        this.interfaceVersion = (byte)52;
        this.bindTimeout = 5000L;
        this.loggingOptions = new LoggingOptions();
        this.windowWaitTimeout = 60000L;
        this.requestExpiryTimeout = -1L;
        this.windowMonitorInterval = -1L;
        this.countersEnabled = false;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setWindowSize(int value) {
        this.windowSize = value;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setBindTimeout(long value) {
        this.bindTimeout = value;
    }

    public long getBindTimeout() {
        return this.bindTimeout;
    }

    public void setType(SmppBindType bindType) {
        this.type = bindType;
    }

    public SmppBindType getType() {
        return this.type;
    }

    public void setSystemId(String value) {
        this.systemId = value;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSystemType(String value) {
        this.systemType = value;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setInterfaceVersion(byte value) {
        this.interfaceVersion = value;
    }

    public byte getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public Address getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(Address value) {
        this.addressRange = value;
    }

    public LoggingOptions getLoggingOptions() {
        return this.loggingOptions;
    }

    public void setLoggingOptions(LoggingOptions loggingOptions) {
        this.loggingOptions = loggingOptions;
    }

    public long getWindowWaitTimeout() {
        return this.windowWaitTimeout;
    }

    public void setWindowWaitTimeout(long windowWaitTimeout) {
        this.windowWaitTimeout = windowWaitTimeout;
    }

    public long getRequestExpiryTimeout() {
        return this.requestExpiryTimeout;
    }

    public void setRequestExpiryTimeout(long requestExpiryTimeout) {
        this.requestExpiryTimeout = requestExpiryTimeout;
    }

    public long getWindowMonitorInterval() {
        return this.windowMonitorInterval;
    }

    public void setWindowMonitorInterval(long windowMonitorInterval) {
        this.windowMonitorInterval = windowMonitorInterval;
    }

    public boolean isCountersEnabled() {
        return this.countersEnabled;
    }

    public void setCountersEnabled(boolean countersEnabled) {
        this.countersEnabled = countersEnabled;
    }
}

