/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.commons.util.PeriodFormatterUtil;
import com.cloudhopper.commons.util.windowing.DuplicateKeyException;
import com.cloudhopper.commons.util.windowing.OfferTimeoutException;
import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.commons.util.windowing.WindowListener;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionCounters;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultPduAsyncResponse;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.DefaultSmppSessionCounters;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.impl.SmppSessionChannelListener;
import com.cloudhopper.smpp.jmx.DefaultSmppSessionMXBean;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.EnquireLinkResp;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.pdu.Unbind;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoder;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoderContext;
import com.cloudhopper.smpp.transcoder.PduTranscoder;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppBindException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.SequenceNumber;
import com.cloudhopper.smpp.util.SmppSessionUtil;
import com.cloudhopper.smpp.util.SmppUtil;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmppSession
implements SmppServerSession,
SmppSessionChannelListener,
WindowListener<Integer, PduRequest, PduResponse>,
DefaultSmppSessionMXBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSmppSession.class);
    private final SmppSession.Type localType;
    private final AtomicInteger state;
    private final AtomicLong boundTime;
    private final SmppSessionConfiguration configuration;
    private final Channel channel;
    private SmppSessionHandler sessionHandler;
    private final SequenceNumber sequenceNumber;
    private final PduTranscoder transcoder;
    private final Window<Integer, PduRequest, PduResponse> sendWindow;
    private byte interfaceVersion;
    private DefaultSmppServer server;
    private Long serverSessionId;
    private BaseBindResp preparedBindResponse;
    private ScheduledExecutorService monitorExecutor;
    private DefaultSmppSessionCounters counters;

    public DefaultSmppSession(SmppSession.Type localType, SmppSessionConfiguration configuration, Channel channel, DefaultSmppServer server, Long serverSessionId, BaseBindResp preparedBindResponse, byte interfaceVersion, ScheduledExecutorService monitorExecutor) {
        this(localType, configuration, channel, null, monitorExecutor);
        this.state.set(2);
        this.server = server;
        this.serverSessionId = serverSessionId;
        this.preparedBindResponse = preparedBindResponse;
        this.interfaceVersion = interfaceVersion;
    }

    public DefaultSmppSession(SmppSession.Type localType, SmppSessionConfiguration configuration, Channel channel, SmppSessionHandler sessionHandler) {
        this(localType, configuration, channel, sessionHandler, null);
    }

    public DefaultSmppSession(SmppSession.Type localType, SmppSessionConfiguration configuration, Channel channel, SmppSessionHandler sessionHandler, ScheduledExecutorService monitorExecutor) {
        this.localType = localType;
        this.state = new AtomicInteger(1);
        this.configuration = configuration;
        this.channel = channel;
        this.boundTime = new AtomicLong(0L);
        this.sessionHandler = sessionHandler == null ? new DefaultSmppSessionHandler(logger) : sessionHandler;
        this.sequenceNumber = new SequenceNumber();
        this.transcoder = new DefaultPduTranscoder(new DefaultPduTranscoderContext(this.sessionHandler));
        this.monitorExecutor = monitorExecutor;
        this.sendWindow = monitorExecutor != null && configuration.getWindowMonitorInterval() > 0L ? new Window(configuration.getWindowSize(), monitorExecutor, configuration.getWindowMonitorInterval(), (WindowListener)this, configuration.getName() + ".Monitor") : new Window(configuration.getWindowSize());
        this.server = null;
        this.serverSessionId = null;
        this.preparedBindResponse = null;
        if (configuration.isCountersEnabled()) {
            this.counters = new DefaultSmppSessionCounters();
        }
    }

    public void registerMBean(String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, name);
        }
        catch (Exception e) {
            logger.error("Unable to register DefaultSmppSessionMXBean [{}]", (Object)objectName, (Object)e);
        }
    }

    public void unregisterMBean(String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (Exception e) {
            logger.error("Unable to unregister DefaultSmppServerMXBean [{}]", (Object)objectName, (Object)e);
        }
    }

    @Override
    public SmppBindType getBindType() {
        return this.configuration.getType();
    }

    @Override
    public SmppSession.Type getLocalType() {
        return this.localType;
    }

    @Override
    public SmppSession.Type getRemoteType() {
        if (this.localType == SmppSession.Type.CLIENT) {
            return SmppSession.Type.SERVER;
        }
        return SmppSession.Type.CLIENT;
    }

    protected void setBound() {
        this.state.set(3);
        this.boundTime.set(System.currentTimeMillis());
    }

    @Override
    public long getBoundTime() {
        return this.boundTime.get();
    }

    @Override
    public String getStateName() {
        int s = this.state.get();
        if (s >= 0 || s < STATES.length) {
            return STATES[s];
        }
        return "UNKNOWN (" + s + ")";
    }

    protected void setInterfaceVersion(byte value) {
        this.interfaceVersion = value;
    }

    @Override
    public byte getInterfaceVersion() {
        return this.interfaceVersion;
    }

    @Override
    public boolean areOptionalParametersSupported() {
        return this.interfaceVersion >= 52;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() == 1;
    }

    @Override
    public boolean isBinding() {
        return this.state.get() == 2;
    }

    @Override
    public boolean isBound() {
        return this.state.get() == 3;
    }

    @Override
    public boolean isUnbinding() {
        return this.state.get() == 4;
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == 5;
    }

    @Override
    public SmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    protected PduTranscoder getTranscoder() {
        return this.transcoder;
    }

    @Override
    public Window<Integer, PduRequest, PduResponse> getRequestWindow() {
        return this.getSendWindow();
    }

    @Override
    public Window<Integer, PduRequest, PduResponse> getSendWindow() {
        return this.sendWindow;
    }

    @Override
    public boolean hasCounters() {
        return this.counters != null;
    }

    @Override
    public SmppSessionCounters getCounters() {
        return this.counters;
    }

    @Override
    public void serverReady(SmppSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
        try {
            this.sendResponsePdu(this.preparedBindResponse);
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
        }
        this.channel.setReadable(true).awaitUninterruptibly();
        this.setBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseBindResp bind(BaseBind request, long timeoutInMillis) throws RecoverablePduException, UnrecoverablePduException, SmppBindException, SmppTimeoutException, SmppChannelException, InterruptedException {
        this.assertValidRequest(request);
        boolean bound = false;
        try {
            this.state.set(2);
            PduResponse response = this.sendRequestAndGetResponse(request, timeoutInMillis);
            SmppSessionUtil.assertExpectedResponse(request, response);
            BaseBindResp bindResponse = (BaseBindResp)response;
            if (bindResponse == null || bindResponse.getCommandStatus() != 0) {
                throw new SmppBindException(bindResponse);
            }
            bound = true;
            Tlv scInterfaceVersion = bindResponse.getOptionalParameter((short)528);
            if (scInterfaceVersion == null) {
                this.interfaceVersion = (byte)51;
            } else {
                try {
                    byte tempInterfaceVersion = scInterfaceVersion.getValueAsByte();
                    this.interfaceVersion = tempInterfaceVersion >= 52 ? (byte)52 : (byte)51;
                }
                catch (TlvConvertException e) {
                    logger.warn("Unable to convert sc_interface_version to a byte value: {}", (Object)e.getMessage());
                    this.interfaceVersion = (byte)51;
                }
            }
            BaseBindResp baseBindResp = bindResponse;
            return baseBindResp;
        }
        finally {
            if (bound) {
                this.setBound();
            } else {
                try {
                    this.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void unbind(long timeoutInMillis) {
        if (this.channel.isConnected()) {
            this.state.set(4);
            try {
                this.sendRequestAndGetResponse(new Unbind(), timeoutInMillis);
            }
            catch (Exception e) {
                logger.warn("Did not cleanly receive an unbind response to our unbind request, safe to ignore: " + e.getMessage());
            }
        } else {
            logger.info("Session channel is already closed, not going to unbind");
        }
        this.close(timeoutInMillis);
    }

    @Override
    public void close() {
        this.close(5000L);
    }

    @Override
    public void close(long timeoutInMillis) {
        if (this.channel.isConnected()) {
            this.state.set(4);
            if (this.channel.close().awaitUninterruptibly(timeoutInMillis)) {
                logger.info("Successfully closed");
            } else {
                logger.warn("Unable to cleanly close channel");
            }
        }
        this.state.set(5);
    }

    @Override
    public void destroy() {
        this.close();
        this.sendWindow.destroy();
        if (this.counters != null) {
            this.counters.reset();
        }
        this.sessionHandler = null;
    }

    @Override
    public EnquireLinkResp enquireLink(EnquireLink request, long timeoutInMillis) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        this.assertValidRequest(request);
        PduResponse response = this.sendRequestAndGetResponse(request, timeoutInMillis);
        SmppSessionUtil.assertExpectedResponse(request, response);
        return (EnquireLinkResp)response;
    }

    @Override
    public SubmitSmResp submit(SubmitSm request, long timeoutInMillis) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        this.assertValidRequest(request);
        PduResponse response = this.sendRequestAndGetResponse(request, timeoutInMillis);
        SmppSessionUtil.assertExpectedResponse(request, response);
        return (SubmitSmResp)response;
    }

    protected void assertValidRequest(PduRequest request) throws NullPointerException, RecoverablePduException, UnrecoverablePduException {
        if (request == null) {
            throw new NullPointerException("PDU request cannot be null");
        }
    }

    protected PduResponse sendRequestAndGetResponse(PduRequest requestPdu, long timeoutInMillis) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        WindowFuture<Integer, PduRequest, PduResponse> future = this.sendRequestPdu(requestPdu, timeoutInMillis, true);
        boolean completedWithinTimeout = future.await();
        if (!completedWithinTimeout) {
            future.cancel();
            throw new SmppTimeoutException("Unable to get response within [" + timeoutInMillis + " ms]");
        }
        if (future.isSuccess()) {
            return (PduResponse)future.getResponse();
        }
        if (future.getCause() != null) {
            Throwable cause = future.getCause();
            if (cause instanceof ClosedChannelException) {
                throw new SmppChannelException("Channel was closed after sending request, but before receiving response", cause);
            }
            throw new UnrecoverablePduException(cause.getMessage(), cause);
        }
        if (future.isCancelled()) {
            throw new RecoverablePduException("Request was cancelled");
        }
        throw new UnrecoverablePduException("Unable to sendRequestAndGetResponse successfully (future was in strange state)");
    }

    @Override
    public WindowFuture<Integer, PduRequest, PduResponse> sendRequestPdu(PduRequest pdu, long timeoutMillis, boolean synchronous) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        ChannelFuture channelFuture;
        if (!pdu.hasSequenceNumberAssigned()) {
            pdu.setSequenceNumber(this.sequenceNumber.next());
        }
        ChannelBuffer buffer = this.transcoder.encode(pdu);
        WindowFuture future = null;
        try {
            future = this.sendWindow.offer((Object)pdu.getSequenceNumber(), (Object)pdu, timeoutMillis, this.configuration.getRequestExpiryTimeout(), synchronous);
        }
        catch (DuplicateKeyException e) {
            throw new UnrecoverablePduException(e.getMessage(), e);
        }
        catch (OfferTimeoutException e) {
            throw new SmppTimeoutException(e.getMessage(), e);
        }
        if (this.configuration.getLoggingOptions().isLogPduEnabled()) {
            if (synchronous) {
                logger.info("sync send PDU: {}", (Object)pdu);
            } else {
                logger.info("async send PDU: {}", (Object)pdu);
            }
        }
        if (!(channelFuture = this.channel.write((Object)buffer).await()).isSuccess()) {
            throw new SmppChannelException(channelFuture.getCause().getMessage(), channelFuture.getCause());
        }
        this.countSendRequestPdu(pdu);
        return future;
    }

    @Override
    public void sendResponsePdu(PduResponse pdu) throws RecoverablePduException, UnrecoverablePduException, SmppChannelException, InterruptedException {
        ChannelFuture channelFuture;
        if (!pdu.hasSequenceNumberAssigned()) {
            pdu.setSequenceNumber(this.sequenceNumber.next());
        }
        ChannelBuffer buffer = this.transcoder.encode(pdu);
        if (this.configuration.getLoggingOptions().isLogPduEnabled()) {
            logger.info("send PDU: {}", (Object)pdu);
        }
        if (!(channelFuture = this.channel.write((Object)buffer).await()).isSuccess()) {
            throw new SmppChannelException(channelFuture.getCause().getMessage(), channelFuture.getCause());
        }
    }

    @Override
    public void firePduReceived(Pdu pdu) {
        if (this.configuration.getLoggingOptions().isLogPduEnabled()) {
            logger.info("received PDU: {}", (Object)pdu);
        }
        if (pdu instanceof PduRequest) {
            PduRequest requestPdu = (PduRequest)pdu;
            this.countReceiveRequestPdu(requestPdu);
            long startTime = System.currentTimeMillis();
            PduResponse responsePdu = this.sessionHandler.firePduRequestReceived(requestPdu);
            if (responsePdu != null) {
                try {
                    long responseTime = System.currentTimeMillis() - startTime;
                    this.countSendResponsePdu(responsePdu, responseTime, responseTime);
                    this.sendResponsePdu(responsePdu);
                }
                catch (Exception e) {
                    logger.error("Unable to cleanly return response PDU: {}", (Throwable)e);
                }
            }
        } else {
            PduResponse responsePdu = (PduResponse)pdu;
            int receivedPduSeqNum = pdu.getSequenceNumber();
            try {
                WindowFuture future = this.sendWindow.complete((Object)receivedPduSeqNum, (Object)responsePdu);
                if (future != null) {
                    logger.trace("Found a future in the window for seqNum [{}]", (Object)receivedPduSeqNum);
                    this.countReceiveResponsePdu(responsePdu, future.getOfferToAcceptTime(), future.getAcceptToDoneTime(), future.getAcceptToDoneTime() / (long)future.getWindowSize());
                    int callerStateHint = future.getCallerStateHint();
                    if (callerStateHint == 1) {
                        logger.trace("Caller waiting for request: {}", future.getRequest());
                        return;
                    }
                    if (callerStateHint == 0) {
                        logger.trace("Caller not waiting for request: {}", future.getRequest());
                        this.sessionHandler.fireExpectedPduResponseReceived(new DefaultPduAsyncResponse((WindowFuture<Integer, PduRequest, PduResponse>)future));
                        return;
                    }
                    logger.trace("Caller timed out waiting for request: {}", future.getRequest());
                    this.sessionHandler.fireUnexpectedPduResponseReceived(responsePdu);
                } else {
                    this.countReceiveResponsePdu(responsePdu, 0L, 0L, 0L);
                    this.sessionHandler.fireUnexpectedPduResponseReceived(responsePdu);
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while attempting to process response PDU and match it to a request via requesWindow: ", (Throwable)e);
            }
        }
    }

    @Override
    public void fireExceptionThrown(Throwable t) {
        if (t instanceof UnrecoverablePduException) {
            this.sessionHandler.fireUnrecoverablePduException((UnrecoverablePduException)t);
        } else if (t instanceof RecoverablePduException) {
            this.sessionHandler.fireRecoverablePduException((RecoverablePduException)t);
        } else if (this.isUnbinding() || this.isClosed()) {
            logger.debug("Unbind/close was requested, ignoring exception thrown: {}", t);
        } else {
            this.sessionHandler.fireUnknownThrowable(t);
        }
    }

    @Override
    public void fireChannelClosed() {
        if (this.server != null) {
            this.server.destroySession(this.serverSessionId, this);
        }
        if (this.sendWindow.getSize() > 0) {
            logger.trace("Channel closed and sendWindow has [{}] outstanding requests, some may need cancelled immediately", (Object)this.sendWindow.getSize());
            Map requests = this.sendWindow.createSortedSnapshot();
            ClosedChannelException cause = new ClosedChannelException();
            for (WindowFuture future : requests.values()) {
                if (!future.isCallerWaiting()) continue;
                logger.debug("Caller waiting on request [{}], cancelling it with a channel closed exception", future.getKey());
                try {
                    future.fail((Throwable)cause);
                }
                catch (Exception e) {}
            }
        }
        if (this.isUnbinding() || this.isClosed()) {
            logger.debug("Unbind/close was requested, ignoring channelClosed event");
        } else {
            this.sessionHandler.fireChannelUnexpectedlyClosed();
        }
    }

    public void expired(WindowFuture<Integer, PduRequest, PduResponse> future) {
        this.countSendRequestPduExpired((PduRequest)future.getRequest());
        this.sessionHandler.firePduRequestExpired((PduRequest)future.getRequest());
    }

    private void countSendRequestPdu(PduRequest pdu) {
        if (this.counters == null) {
            return;
        }
        if (pdu.isRequest()) {
            switch (pdu.getCommandId()) {
                case 4: {
                    this.counters.getTxSubmitSM().incrementRequestAndGet();
                    break;
                }
                case 5: {
                    this.counters.getTxDeliverSM().incrementRequestAndGet();
                    break;
                }
                case 259: {
                    this.counters.getTxDataSM().incrementRequestAndGet();
                    break;
                }
                case 21: {
                    this.counters.getTxEnquireLink().incrementRequestAndGet();
                }
            }
        }
    }

    private void countSendResponsePdu(PduResponse pdu, long responseTime, long estimatedProcessingTime) {
        if (this.counters == null) {
            return;
        }
        if (pdu.isResponse()) {
            switch (pdu.getCommandId()) {
                case -2147483644: {
                    this.counters.getRxSubmitSM().incrementResponseAndGet();
                    this.counters.getRxSubmitSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getRxSubmitSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getRxSubmitSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483643: {
                    this.counters.getRxDeliverSM().incrementResponseAndGet();
                    this.counters.getRxDeliverSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getRxDeliverSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getRxDeliverSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483389: {
                    this.counters.getRxDataSM().incrementResponseAndGet();
                    this.counters.getRxDataSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getRxDataSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getRxDataSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483627: {
                    this.counters.getRxEnquireLink().incrementResponseAndGet();
                    this.counters.getRxEnquireLink().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getRxEnquireLink().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getRxEnquireLink().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                }
            }
        }
    }

    private void countSendRequestPduExpired(PduRequest pdu) {
        if (this.counters == null) {
            return;
        }
        if (pdu.isRequest()) {
            switch (pdu.getCommandId()) {
                case 4: {
                    this.counters.getTxSubmitSM().incrementRequestExpiredAndGet();
                    break;
                }
                case 5: {
                    this.counters.getTxDeliverSM().incrementRequestExpiredAndGet();
                    break;
                }
                case 259: {
                    this.counters.getTxDataSM().incrementRequestExpiredAndGet();
                    break;
                }
                case 21: {
                    this.counters.getTxEnquireLink().incrementRequestExpiredAndGet();
                }
            }
        }
    }

    private void countReceiveRequestPdu(PduRequest pdu) {
        if (this.counters == null) {
            return;
        }
        if (pdu.isRequest()) {
            switch (pdu.getCommandId()) {
                case 4: {
                    this.counters.getRxSubmitSM().incrementRequestAndGet();
                    break;
                }
                case 5: {
                    this.counters.getRxDeliverSM().incrementRequestAndGet();
                    break;
                }
                case 259: {
                    this.counters.getRxDataSM().incrementRequestAndGet();
                    break;
                }
                case 21: {
                    this.counters.getRxEnquireLink().incrementRequestAndGet();
                }
            }
        }
    }

    private void countReceiveResponsePdu(PduResponse pdu, long waitTime, long responseTime, long estimatedProcessingTime) {
        if (this.counters == null) {
            return;
        }
        if (pdu.isResponse()) {
            switch (pdu.getCommandId()) {
                case -2147483644: {
                    this.counters.getTxSubmitSM().incrementResponseAndGet();
                    this.counters.getTxSubmitSM().addRequestWaitTimeAndGet(waitTime);
                    this.counters.getTxSubmitSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getTxSubmitSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getTxSubmitSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483643: {
                    this.counters.getTxDeliverSM().incrementResponseAndGet();
                    this.counters.getTxDeliverSM().addRequestWaitTimeAndGet(waitTime);
                    this.counters.getTxDeliverSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getTxDeliverSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getTxDeliverSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483389: {
                    this.counters.getTxDataSM().incrementResponseAndGet();
                    this.counters.getTxDataSM().addRequestWaitTimeAndGet(waitTime);
                    this.counters.getTxDataSM().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getTxDataSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getTxDataSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483627: {
                    this.counters.getTxEnquireLink().incrementResponseAndGet();
                    this.counters.getTxEnquireLink().addRequestWaitTimeAndGet(waitTime);
                    this.counters.getTxEnquireLink().addRequestResponseTimeAndGet(responseTime);
                    this.counters.getTxEnquireLink().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    this.counters.getTxEnquireLink().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                }
            }
        }
    }

    @Override
    public void resetCounters() {
        if (this.hasCounters()) {
            this.counters.reset();
        }
    }

    @Override
    public String getBindTypeName() {
        return this.getBindType().toString();
    }

    @Override
    public String getBoundDuration() {
        return PeriodFormatterUtil.toLinuxUptimeStyleString((long)(System.currentTimeMillis() - this.getBoundTime()));
    }

    @Override
    public String getInterfaceVersionName() {
        return SmppUtil.toInterfaceVersionString(this.interfaceVersion);
    }

    @Override
    public String getLocalTypeName() {
        return this.getLocalType().toString();
    }

    @Override
    public String getRemoteTypeName() {
        return this.getRemoteType().toString();
    }

    @Override
    public int getNextSequenceNumber() {
        return this.sequenceNumber.peek();
    }

    @Override
    public String getLocalAddressAndPort() {
        if (this.channel != null) {
            InetSocketAddress addr = (InetSocketAddress)this.channel.getLocalAddress();
            return addr.getAddress().getHostAddress() + ":" + addr.getPort();
        }
        return null;
    }

    @Override
    public String getRemoteAddressAndPort() {
        if (this.channel != null) {
            InetSocketAddress addr = (InetSocketAddress)this.channel.getRemoteAddress();
            return addr.getAddress().getHostAddress() + ":" + addr.getPort();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    @Override
    public String getPassword() {
        return this.configuration.getPassword();
    }

    @Override
    public long getRequestExpiryTimeout() {
        return this.configuration.getRequestExpiryTimeout();
    }

    @Override
    public String getSystemId() {
        return this.configuration.getSystemId();
    }

    @Override
    public String getSystemType() {
        return this.configuration.getSystemType();
    }

    @Override
    public boolean isWindowMonitorEnabled() {
        return this.monitorExecutor != null && this.configuration.getWindowMonitorInterval() > 0L;
    }

    @Override
    public long getWindowMonitorInterval() {
        return this.configuration.getWindowMonitorInterval();
    }

    @Override
    public int getMaxWindowSize() {
        return this.sendWindow.getMaxSize();
    }

    @Override
    public int getWindowSize() {
        return this.sendWindow.getSize();
    }

    @Override
    public long getWindowWaitTimeout() {
        return this.configuration.getWindowWaitTimeout();
    }

    @Override
    public String[] dumpWindow() {
        Map sortedSnapshot = this.sendWindow.createSortedSnapshot();
        String[] dump = new String[sortedSnapshot.size()];
        int i = 0;
        for (WindowFuture future : sortedSnapshot.values()) {
            dump[i] = ((PduRequest)future.getRequest()).toString();
            ++i;
        }
        return dump;
    }

    @Override
    public String getRxDataSMCounter() {
        return this.hasCounters() ? this.counters.getRxDataSM().toString() : null;
    }

    @Override
    public String getRxDeliverSMCounter() {
        return this.hasCounters() ? this.counters.getRxDeliverSM().toString() : null;
    }

    @Override
    public String getRxEnquireLinkCounter() {
        return this.hasCounters() ? this.counters.getRxEnquireLink().toString() : null;
    }

    @Override
    public String getRxSubmitSMCounter() {
        return this.hasCounters() ? this.counters.getRxSubmitSM().toString() : null;
    }

    @Override
    public String getTxDataSMCounter() {
        return this.hasCounters() ? this.counters.getTxDataSM().toString() : null;
    }

    @Override
    public String getTxDeliverSMCounter() {
        return this.hasCounters() ? this.counters.getTxDeliverSM().toString() : null;
    }

    @Override
    public String getTxEnquireLinkCounter() {
        return this.hasCounters() ? this.counters.getTxEnquireLink().toString() : null;
    }

    @Override
    public String getTxSubmitSMCounter() {
        return this.hasCounters() ? this.counters.getTxSubmitSM().toString() : null;
    }

    @Override
    public void enableLogBytes() {
        this.configuration.getLoggingOptions().setLogBytes(true);
    }

    @Override
    public void disableLogBytes() {
        this.configuration.getLoggingOptions().setLogBytes(false);
    }

    @Override
    public void enableLogPdu() {
        this.configuration.getLoggingOptions().setLogPdu(true);
    }

    @Override
    public void disableLogPdu() {
        this.configuration.getLoggingOptions().setLogPdu(false);
    }
}

