/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.script.GroovyAction;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;

public class GroovyActionBuilder
extends AbstractTestActionBuilder<GroovyAction> {
    public GroovyActionBuilder(GroovyAction action) {
        super(action);
    }

    public GroovyActionBuilder() {
        super(new GroovyAction());
    }

    public GroovyActionBuilder script(String script) {
        ((GroovyAction)this.action).setScript(script);
        return this;
    }

    public GroovyActionBuilder script(Resource scriptResource) {
        return this.script(scriptResource, FileUtils.getDefaultCharset());
    }

    public GroovyActionBuilder script(Resource scriptResource, Charset charset) {
        try {
            ((GroovyAction)this.action).setScript(FileUtils.readToString((Resource)scriptResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
        }
        return this;
    }

    public GroovyActionBuilder template(String scriptTemplatePath) {
        ((GroovyAction)this.action).setScriptTemplatePath(scriptTemplatePath);
        return this;
    }

    public GroovyActionBuilder template(Resource scriptTemplate) {
        return this.template(scriptTemplate, FileUtils.getDefaultCharset());
    }

    public GroovyActionBuilder template(Resource scriptTemplate, Charset charset) {
        try {
            ((GroovyAction)this.action).setScriptTemplate(FileUtils.readToString((Resource)scriptTemplate, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script template file", (Throwable)e);
        }
        return this;
    }

    public GroovyActionBuilder skipTemplate() {
        ((GroovyAction)this.action).setUseScriptTemplate(false);
        return this;
    }
}

