/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class HttpClientRequestActionBuilder
extends SendMessageBuilder<SendMessageAction, HttpClientRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendMessageAction());
        this.getAction().setEndpoint(httpClient);
        this.message((Message)this.httpMessage);
    }

    public HttpClientRequestActionBuilder(DelegatingTestAction<TestAction> delegate, String httpClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendMessageAction());
        this.getAction().setEndpointUri(httpClientUri);
        this.message((Message)this.httpMessage);
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    public HttpClientRequestActionBuilder payload(MultiValueMap<String, Object> payload) {
        this.httpMessage.setPayload(payload);
        return this;
    }

    @Override
    public HttpClientRequestActionBuilder name(String name) {
        this.httpMessage.setName(name);
        return (HttpClientRequestActionBuilder)super.name(name);
    }

    public HttpClientRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpClientRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpClientRequestActionBuilder uri(String uri) {
        this.httpMessage.uri(uri);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpClientRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpClientRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }

    public HttpClientRequestActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    @Override
    public HttpClientRequestActionBuilder message(Message message) {
        if (message instanceof HttpMessage) {
            if (this.httpMessage.getRequestMethod() != null) {
                ((HttpMessage)message).method(this.httpMessage.getRequestMethod());
            }
            if (StringUtils.hasText((String)this.httpMessage.getPath())) {
                ((HttpMessage)message).path(this.httpMessage.getPath());
            }
            if (StringUtils.hasText((String)this.httpMessage.getUri())) {
                ((HttpMessage)message).uri(this.httpMessage.getUri());
            }
            if (StringUtils.hasText((String)this.httpMessage.getQueryParams())) {
                ((HttpMessage)message).queryParams(this.httpMessage.getQueryParams());
            }
            this.httpMessage = (HttpMessage)message;
        } else {
            this.httpMessage = new HttpMessage(message);
        }
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
        return this;
    }
}

