/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class HttpServerRequestActionBuilder
extends ReceiveMessageBuilder<ReceiveMessageAction, HttpServerRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpServerRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpServer) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpoint(httpServer);
        this.message((Message)this.httpMessage);
        this.messageType(MessageType.XML);
        this.headerNameIgnoreCase(true);
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    @Override
    public HttpServerRequestActionBuilder name(String name) {
        this.httpMessage.setName(name);
        return (HttpServerRequestActionBuilder)super.name(name);
    }

    public HttpServerRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpServerRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpServerRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpServerRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpServerRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }

    public HttpServerRequestActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    @Override
    public HttpServerRequestActionBuilder message(Message message) {
        if (message instanceof HttpMessage) {
            if (this.httpMessage.getRequestMethod() != null) {
                ((HttpMessage)message).method(this.httpMessage.getRequestMethod());
            }
            if (StringUtils.hasText((String)this.httpMessage.getPath())) {
                ((HttpMessage)message).path(this.httpMessage.getPath());
            }
            if (StringUtils.hasText((String)this.httpMessage.getQueryParams())) {
                ((HttpMessage)message).queryParams(this.httpMessage.getQueryParams());
            }
            this.httpMessage = (HttpMessage)message;
        } else {
            this.httpMessage = new HttpMessage(message);
        }
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
        return this;
    }
}

