/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.SendMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.actions.SendSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

public class SoapServerResponseActionBuilder
extends SendMessageBuilder<SendSoapMessageAction, SoapServerResponseActionBuilder> {
    private SoapMessage soapMessage = new SoapMessage();

    public SoapServerResponseActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint soapServer) {
        super(delegate);
        delegate.setDelegate((TestAction)new SendSoapMessageAction());
        this.getAction().setEndpoint(soapServer);
        this.message((Message)this.soapMessage);
    }

    @Override
    protected void setPayload(String payload) {
        this.soapMessage.setPayload((Object)payload);
    }

    public SoapServerResponseActionBuilder attachment(String contentId, String contentType, String content) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        attachment.setContent(content);
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapServerResponseActionBuilder attachment(String contentId, String contentType, Resource contentResource) {
        return this.attachment(contentId, contentType, contentResource, FileUtils.getDefaultCharset());
    }

    public SoapServerResponseActionBuilder attachment(String contentId, String contentType, Resource contentResource, Charset charset) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        try {
            attachment.setContent(FileUtils.readToString((Resource)contentResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read attachment resource", (Throwable)e);
        }
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapServerResponseActionBuilder charset(String charsetName) {
        if (!this.getAction().getAttachments().isEmpty()) {
            ((SoapAttachment)this.getAction().getAttachments().get(this.getAction().getAttachments().size() - 1)).setCharsetName(charsetName);
        }
        return this;
    }

    public SoapServerResponseActionBuilder attachment(SoapAttachment attachment) {
        this.soapMessage.addAttachment(attachment);
        return this;
    }

    public SoapServerResponseActionBuilder status(HttpStatus status) {
        this.soapMessage.header("citrus_http_status_code", (Object)status.value());
        return this;
    }

    public SoapServerResponseActionBuilder statusCode(Integer statusCode) {
        this.soapMessage.header("citrus_http_status_code", (Object)statusCode);
        return this;
    }

    public SoapServerResponseActionBuilder contentType(String contentType) {
        this.soapMessage.header("citrus_http_Content-Type", (Object)contentType);
        return this;
    }

    public SoapServerResponseActionBuilder mtomEnabled(boolean mtomEnabled) {
        this.soapMessage.mtomEnabled(mtomEnabled);
        this.getAction().setMtomEnabled(mtomEnabled);
        return this;
    }

    protected SendSoapMessageAction getAction() {
        return (SendSoapMessageAction)super.getAction();
    }
}

