/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.actions.TransformAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;

public class TransformActionBuilder
extends AbstractTestActionBuilder<TransformAction> {
    public TransformActionBuilder(TransformAction action) {
        super(action);
    }

    public TransformActionBuilder() {
        super(new TransformAction());
    }

    public TransformActionBuilder result(String variable) {
        ((TransformAction)this.action).setTargetVariable(variable);
        return this;
    }

    public TransformActionBuilder source(String xmlData) {
        ((TransformAction)this.action).setXmlData(xmlData);
        return this;
    }

    public TransformActionBuilder source(Resource xmlResource) {
        return this.source(xmlResource, FileUtils.getDefaultCharset());
    }

    public TransformActionBuilder source(Resource xmlResource, Charset charset) {
        try {
            ((TransformAction)this.action).setXmlData(FileUtils.readToString((Resource)xmlResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read xml resource", (Throwable)e);
        }
        return this;
    }

    public TransformActionBuilder xslt(String xsltData) {
        ((TransformAction)this.action).setXsltData(xsltData);
        return this;
    }

    public TransformActionBuilder xslt(Resource xsltResource) {
        return this.xslt(xsltResource, FileUtils.getDefaultCharset());
    }

    public TransformActionBuilder xslt(Resource xsltResource, Charset charset) {
        try {
            ((TransformAction)this.action).setXsltData(FileUtils.readToString((Resource)xsltResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read xstl resource", (Throwable)e);
        }
        return this;
    }
}

