/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.couchbase.client.core.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.core.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.core.deps.io.netty.handler.timeout.IdleStateHandler;
import com.couchbase.client.core.deps.io.netty.util.AttributeKey;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.DefaultConnectionNameGenerator;
import com.couchbase.client.dcp.buffer.PersistencePollingHandler;
import com.couchbase.client.dcp.conductor.BucketConfigArbiter;
import com.couchbase.client.dcp.conductor.DcpChannel;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.core.utils.CbStrings;
import com.couchbase.client.dcp.metrics.DcpChannelMetrics;
import com.couchbase.client.dcp.metrics.DcpClientMetrics;
import com.couchbase.client.dcp.transport.netty.BucketConfigHandler;
import com.couchbase.client.dcp.transport.netty.ClientNoopHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import com.couchbase.client.dcp.transport.netty.DcpControlHandler;
import com.couchbase.client.dcp.transport.netty.DcpLoggingHandler;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.FlowControlDiagnosticHandler;
import com.couchbase.client.dcp.transport.netty.HandshakeTimeoutHandler;
import com.couchbase.client.dcp.transport.netty.SslHandlerFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpPipeline
extends ChannelInitializer<Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpPipeline.class);
    private static final AttributeKey<Object> DESCRIPTION = AttributeKey.valueOf((String)"desc");
    private final Client.Environment environment;
    private final DcpChannelControlHandler controlHandler;
    private final BucketConfigArbiter bucketConfigArbiter;
    private final DcpChannelMetrics metrics;
    private final DcpClientMetrics clientMetrics;

    public DcpPipeline(Client.Environment environment, DcpChannelControlHandler controlHandler, BucketConfigArbiter bucketConfigArbiter, DcpChannelMetrics metrics, DcpClientMetrics clientMetrics) {
        this.bucketConfigArbiter = Objects.requireNonNull(bucketConfigArbiter);
        this.environment = Objects.requireNonNull(environment);
        this.controlHandler = Objects.requireNonNull(controlHandler);
        this.metrics = Objects.requireNonNull(metrics);
        this.clientMetrics = Objects.requireNonNull(clientMetrics);
    }

    public static Object describe(ChannelHandlerContext ctx) {
        return DcpPipeline.describe(ctx.channel());
    }

    public static Object describe(Channel ch) {
        return ch.attr(DESCRIPTION).get();
    }

    protected void initChannel(Channel ch) throws Exception {
        String connectionName = this.environment.connectionNameGenerator().name();
        String connectionId = (String)CbObjects.defaultIfNull((Object)DefaultConnectionNameGenerator.extractConnectionId(connectionName), () -> CbStrings.truncate(connectionName, 64));
        String channelDesc = "Channel{id='" + connectionId + "', remote=" + DcpChannel.getHostAndPort(ch) + "}";
        ch.attr(DESCRIPTION).set((Object)channelDesc);
        ChannelPipeline pipeline = ch.pipeline();
        int gracePeriodMillis = Integer.parseInt(System.getProperty("com.couchbase.connectCallbackGracePeriod", "2000"));
        if (gracePeriodMillis != 0) {
            long handshakeTimeoutMillis = this.environment.socketConnectTimeout() + (long)gracePeriodMillis;
            pipeline.addLast(new ChannelHandler[]{new HandshakeTimeoutHandler(handshakeTimeoutMillis, TimeUnit.MILLISECONDS)});
        }
        if (this.environment.securityConfig().tlsEnabled()) {
            pipeline.addLast(new ChannelHandler[]{SslHandlerFactory.get(ch.alloc(), this.environment.securityConfig(), DcpChannel.getHostAndPort(ch), this.environment.authenticator())});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 8, 4, 12, 0, false)});
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        pipeline.addLast(new ChannelHandler[]{new FlowControlDiagnosticHandler(channelDesc)});
        DcpControl control = this.environment.dcpControl();
        this.environment.authenticator().authKeyValueConnection(pipeline);
        pipeline.addLast(new ChannelHandler[]{new BucketConfigHandler(this.bucketConfigArbiter, this.environment.configRefreshInterval())}).addLast(new ChannelHandler[]{new DcpConnectHandler(this.environment, connectionName)}).addLast(new ChannelHandler[]{new DcpControlHandler(control)});
        if (control.noopEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(2 * control.noopIntervalSeconds(), 0, 0)});
            long serverNoopIntervalMillis = TimeUnit.SECONDS.toMillis(control.noopIntervalSeconds());
            long clientNoopIntervalMillis = (long)((double)serverNoopIntervalMillis * 1.2);
            pipeline.addLast(new ChannelHandler[]{new ClientNoopHandler(clientNoopIntervalMillis, TimeUnit.MILLISECONDS)});
        }
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new DcpLoggingHandler(LogLevel.TRACE)});
        }
        DcpMessageHandler messageHandler = new DcpMessageHandler(ch, this.environment, this.controlHandler, this.metrics);
        pipeline.addLast(new ChannelHandler[]{messageHandler});
        if (this.environment.persistencePollingEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new PersistencePollingHandler(this.environment, this.bucketConfigArbiter, messageHandler, this.clientMetrics)});
        }
    }
}

