/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.util.PartitionSet;
import com.couchbase.connect.kafka.util.ConnectHelper;
import com.couchbase.connect.kafka.util.Version;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorLifecycle {
    private final LogLevel logLevel = LogLevel.INFO;
    private final String uuid = UUID.randomUUID().toString();

    public void logConnectorStarted(String name) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("connectorVersion", Version.getVersion());
        details.put("connectorName", name);
        this.logMilestone(Milestone.CONNECTOR_STARTED, details);
    }

    public void logPartitionsAssigned(List<PartitionSet> partitions) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        for (int i = 0; i < partitions.size(); ++i) {
            details.put("task" + i, partitions.get(i).format());
        }
        this.logMilestone(Milestone.PARTITIONS_ASSIGNED, details);
    }

    public void logConnectorStopped() {
        this.logMilestone(Milestone.CONNECTOR_STOPPED, Collections.emptyMap());
    }

    private void logMilestone(Milestone milestone, Map<String, Object> milestoneDetails) {
        if (this.enabled()) {
            LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
            message.put("milestone", (Object)milestone);
            message.put("connectorUuid", this.uuid);
            ConnectHelper.getTaskIdFromLoggingContext().ifPresent(id -> message.put("taskId", id));
            message.putAll(milestoneDetails);
            this.doLog(milestone.logger, message);
        }
    }

    private void doLog(Logger logger, Object message) {
        try {
            this.logLevel.log(logger, Mapper.encodeAsString((Object)message));
        }
        catch (Exception e) {
            this.logLevel.log(logger, message.toString());
        }
    }

    private boolean enabled() {
        return true;
    }

    public static enum Milestone {
        CONNECTOR_STARTED,
        CONNECTOR_STOPPED,
        PARTITIONS_ASSIGNED;

        private final Logger logger = LoggerFactory.getLogger((String)(ConnectorLifecycle.class.getName() + "." + this.name()));
    }
}

