/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.MutationMetadata;
import com.couchbase.connect.kafka.handler.source.RawJsonSourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawJsonWithMetadataSourceHandler
extends RawJsonSourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawJsonWithMetadataSourceHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final byte[] contentFieldNameBytes = ",\"content\":".getBytes(StandardCharsets.UTF_8);

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        if (!this.buildValue(params, builder)) {
            return null;
        }
        return builder.topic(this.getTopic(params)).key(Schema.STRING_SCHEMA, params.documentEvent().key());
    }

    @Override
    protected boolean buildValue(SourceHandlerParams params, SourceRecordBuilder builder) {
        if (!super.buildValue(params, builder)) {
            return false;
        }
        DocumentEvent docEvent = params.documentEvent();
        DocumentEvent.Type type = docEvent.type();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("event", type.schemaName());
        metadata.put("bucket", docEvent.bucket());
        metadata.put("partition", docEvent.partition());
        metadata.put("vBucketUuid", docEvent.partitionUuid());
        metadata.put("key", docEvent.key());
        metadata.put("cas", docEvent.cas());
        metadata.put("bySeqno", docEvent.bySeqno());
        metadata.put("revSeqno", docEvent.revisionSeqno());
        MutationMetadata mutation = docEvent.mutationMetadata().orElse(null);
        if (mutation != null) {
            metadata.put("expiration", mutation.expiry());
            metadata.put("flags", mutation.flags());
            metadata.put("lockTime", mutation.lockTime());
        } else if (type != DocumentEvent.Type.DELETION && type != DocumentEvent.Type.EXPIRATION) {
            LOGGER.warn("unexpected event type");
            return false;
        }
        this.customizeMetadata(docEvent, metadata);
        try {
            byte[] value = objectMapper.writeValueAsBytes(metadata);
            if (docEvent.isMutation() && !params.noValue()) {
                value = RawJsonWithMetadataSourceHandler.withContentField(value, docEvent.content());
            }
            builder.value(null, value);
            return true;
        }
        catch (JsonProcessingException e) {
            throw new DataException("Failed to serialize event metadata", (Throwable)e);
        }
    }

    protected void customizeMetadata(DocumentEvent docEvent, Map<String, Object> metadata) {
    }

    protected static byte[] withContentField(byte[] metadata, byte[] documentContent) {
        int resultLength = metadata.length + contentFieldNameBytes.length + documentContent.length;
        return new ByteArrayBuilder(resultLength).append(metadata, metadata.length - 1).append(contentFieldNameBytes).append(documentContent).append((byte)125).build();
    }

    protected static class ByteArrayBuilder {
        private final byte[] bytes;
        private int destIndex = 0;

        public ByteArrayBuilder(int finalSize) {
            this.bytes = new byte[finalSize];
        }

        public ByteArrayBuilder append(byte[] source, int len) {
            System.arraycopy(source, 0, this.bytes, this.destIndex, len);
            this.destIndex += len;
            return this;
        }

        public ByteArrayBuilder append(byte[] source) {
            return this.append(source, source.length);
        }

        public ByteArrayBuilder append(byte b) {
            this.bytes[this.destIndex++] = b;
            return this;
        }

        public byte[] build() {
            if (this.destIndex != this.bytes.length) {
                throw new IllegalStateException("Byte array not sized properly. Expected " + this.bytes.length + " bytes but got " + this.destIndex);
            }
            return this.bytes;
        }
    }
}

