/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import com.coveo.saml.LogoutRequestSchemaValidator;
import com.coveo.saml.ResponseSchemaValidator;
import com.coveo.saml.SamlException;
import java.time.Instant;
import java.util.List;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;

class ValidatorUtils {
    ValidatorUtils() {
    }

    private static void validateResponse(StatusResponseType response, String responseIssuer) throws SamlException {
        try {
            new ResponseSchemaValidator().validate(response);
        }
        catch (SamlException e) {
            throw new SamlException("The response schema validation failed", e);
        }
        ValidatorUtils.validateIssuer(response, responseIssuer);
    }

    private static void validateStatus(StatusResponseType response) throws SamlException {
        String statusCode = response.getStatus().getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            throw new SamlException("Invalid status code: " + statusCode);
        }
    }

    private static void validateIssuer(StatusResponseType response, String responseIssuer) throws SamlException {
        if (!response.getIssuer().getValue().equals(responseIssuer)) {
            throw new SamlException("The response issuer didn't match the expected value");
        }
    }

    private static void validateIssuer(RequestAbstractType request, String requestIssuer) throws SamlException {
        if (!request.getIssuer().getValue().equals(requestIssuer)) {
            throw new SamlException("The request issuer didn't match the expected value");
        }
    }

    private static void validateAssertion(Response response, String responseIssuer, Instant now, long notBeforeSkew) throws SamlException {
        if (response.getAssertions().size() != 1) {
            throw new SamlException("The response doesn't contain exactly 1 assertion");
        }
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        if (!assertion.getIssuer().getValue().equals(responseIssuer)) {
            throw new SamlException("The assertion issuer didn't match the expected value");
        }
        if (assertion.getSubject().getNameID() == null) {
            throw new SamlException("The NameID value is missing from the SAML response; this is likely an IDP configuration issue");
        }
        ValidatorUtils.enforceConditions(assertion.getConditions(), now, notBeforeSkew);
    }

    private static void enforceConditions(Conditions conditions, Instant _now, long notBeforeSkew) throws SamlException {
        Instant notBefore;
        Instant skewedNotBefore;
        Instant now = _now != null ? _now : Instant.now();
        if (now.isBefore(skewedNotBefore = (notBefore = conditions.getNotBefore()).minusSeconds(notBeforeSkew))) {
            throw new SamlException("The assertion cannot be used before " + notBefore.toString());
        }
        Instant notOnOrAfter = conditions.getNotOnOrAfter();
        if (now.isAfter(notOnOrAfter)) {
            throw new SamlException("The assertion cannot be used after  " + notOnOrAfter.toString());
        }
    }

    private static void validateSignature(SignableSAMLObject response, List<Credential> credentials) throws SamlException {
        if (response.getSignature() != null && !ValidatorUtils.validate(response.getSignature(), credentials)) {
            throw new SamlException("The response signature is invalid");
        }
    }

    private static void validateAssertionSignature(Response response, List<Credential> credentials) throws SamlException {
        Signature assertionSignature = ((Assertion)response.getAssertions().get(0)).getSignature();
        if (response.getSignature() == null && assertionSignature == null) {
            throw new SamlException("No signature is present in either response or assertion");
        }
        if (assertionSignature != null && !ValidatorUtils.validate(assertionSignature, credentials)) {
            throw new SamlException("The assertion signature is invalid");
        }
    }

    private static boolean validate(Signature signature, List<Credential> credentials) {
        if (signature == null) {
            return false;
        }
        return credentials.stream().anyMatch(credential -> {
            try {
                SignatureValidator.validate((Signature)signature, (Credential)credential);
                return true;
            }
            catch (IllegalArgumentException | SignatureException ex) {
                return false;
            }
        });
    }

    public static void validate(Response response, String responseIssuer, List<Credential> credentials, Instant now, long notBeforeSkew) throws SamlException {
        ValidatorUtils.validateResponse(response, responseIssuer);
        ValidatorUtils.validateAssertion(response, responseIssuer, now, notBeforeSkew);
        ValidatorUtils.validateSignature((SignableSAMLObject)response, credentials);
        ValidatorUtils.validateAssertionSignature(response, credentials);
    }

    public static void validate(LogoutRequest logoutRequest, String responseIssuer, List<Credential> credentials, String nameID) throws SamlException {
        ValidatorUtils.validateLogoutRequest(logoutRequest, responseIssuer, nameID);
        ValidatorUtils.validateSignature((SignableSAMLObject)logoutRequest, credentials);
    }

    public static void validate(LogoutResponse response, String responseIssuer, List<Credential> credentials) throws SamlException {
        ValidatorUtils.validateResponse((StatusResponseType)response, responseIssuer);
        ValidatorUtils.validateSignature((SignableSAMLObject)response, credentials);
    }

    private static void validateResponse(Response response, String responseIssuer) throws SamlException {
        try {
            new ResponseSchemaValidator().validate((StatusResponseType)response);
        }
        catch (SamlException ex) {
            throw new SamlException("The response schema validation failed", ex);
        }
        ValidatorUtils.validateIssuer((StatusResponseType)response, responseIssuer);
        ValidatorUtils.validateStatus((StatusResponseType)response);
    }

    private static void validateLogoutRequest(LogoutRequest request, String requestIssuer, String nameID) throws SamlException {
        try {
            new LogoutRequestSchemaValidator().validate(request);
        }
        catch (SamlException ex) {
            throw new SamlException("The request schema validation failed", ex);
        }
        ValidatorUtils.validateIssuer((RequestAbstractType)request, requestIssuer);
        ValidatorUtils.validateNameId(request, nameID);
    }

    private static void validateNameId(LogoutRequest request, String nameID) throws SamlException {
        if (nameID == null || !nameID.equals(request.getNameID().getValue())) {
            throw new SamlException("The nameID of the logout request is incorrect");
        }
    }
}

