/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsFilter;
import com.datadog.api.client.v1.model.LogsProcessor;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"filter", "id", "is_enabled", "is_read_only", "name", "processors", "type"})
public class LogsPipeline {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROCESSORS = "processors";
    private List<LogsProcessor> processors = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public LogsPipeline() {
    }

    @JsonCreator
    public LogsPipeline(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public LogsPipeline filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public LogsPipeline isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Nullable
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public LogsPipeline name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsPipeline processors(List<LogsProcessor> processors) {
        this.processors = processors;
        for (LogsProcessor item : processors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsPipeline addProcessorsItem(LogsProcessor processorsItem) {
        if (this.processors == null) {
            this.processors = new ArrayList<LogsProcessor>();
        }
        this.processors.add(processorsItem);
        this.unparsed |= processorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="processors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<LogsProcessor> processors) {
        this.processors = processors;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonAnySetter
    public LogsPipeline putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsPipeline logsPipeline = (LogsPipeline)o;
        return Objects.equals(this.filter, logsPipeline.filter) && Objects.equals(this.id, logsPipeline.id) && Objects.equals(this.isEnabled, logsPipeline.isEnabled) && Objects.equals(this.isReadOnly, logsPipeline.isReadOnly) && Objects.equals(this.name, logsPipeline.name) && Objects.equals(this.processors, logsPipeline.processors) && Objects.equals(this.type, logsPipeline.type) && Objects.equals(this.additionalProperties, logsPipeline.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.id, this.isEnabled, this.isReadOnly, this.name, this.processors, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsPipeline {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    processors: ").append(this.toIndentedString(this.processors)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

