/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsUserAgentParserType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"is_enabled", "is_encoded", "name", "sources", "target", "type"})
public class LogsUserAgentParser {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_IS_ENCODED = "is_encoded";
    private Boolean isEncoded = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target = "http.useragent_details";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsUserAgentParserType type = LogsUserAgentParserType.USER_AGENT_PARSER;
    private Map<String, Object> additionalProperties;

    public LogsUserAgentParser() {
    }

    @JsonCreator
    public LogsUserAgentParser(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsUserAgentParserType type) {
        this.sources = sources;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsUserAgentParser isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsUserAgentParser isEncoded(Boolean isEncoded) {
        this.isEncoded = isEncoded;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_encoded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEncoded() {
        return this.isEncoded;
    }

    public void setIsEncoded(Boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    public LogsUserAgentParser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsUserAgentParser sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsUserAgentParser addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsUserAgentParser target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsUserAgentParser type(LogsUserAgentParserType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsUserAgentParserType getType() {
        return this.type;
    }

    public void setType(LogsUserAgentParserType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public LogsUserAgentParser putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsUserAgentParser logsUserAgentParser = (LogsUserAgentParser)o;
        return Objects.equals(this.isEnabled, logsUserAgentParser.isEnabled) && Objects.equals(this.isEncoded, logsUserAgentParser.isEncoded) && Objects.equals(this.name, logsUserAgentParser.name) && Objects.equals(this.sources, logsUserAgentParser.sources) && Objects.equals(this.target, logsUserAgentParser.target) && Objects.equals(this.type, logsUserAgentParser.type) && Objects.equals(this.additionalProperties, logsUserAgentParser.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.isEncoded, this.name, this.sources, this.target, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsUserAgentParser {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isEncoded: ").append(this.toIndentedString(this.isEncoded)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

