/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppPipelineLevel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "ci_level", "tags"})
public class CIAppPipelineEventAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = null;
    public static final String JSON_PROPERTY_CI_LEVEL = "ci_level";
    private CIAppPipelineLevel ciLevel;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public CIAppPipelineEventAttributes attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CIAppPipelineEventAttributes putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public CIAppPipelineEventAttributes ciLevel(CIAppPipelineLevel ciLevel) {
        this.ciLevel = ciLevel;
        this.unparsed |= !ciLevel.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="ci_level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppPipelineLevel getCiLevel() {
        return this.ciLevel;
    }

    public void setCiLevel(CIAppPipelineLevel ciLevel) {
        if (!ciLevel.isValid()) {
            this.unparsed = true;
        }
        this.ciLevel = ciLevel;
    }

    public CIAppPipelineEventAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CIAppPipelineEventAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public CIAppPipelineEventAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppPipelineEventAttributes ciAppPipelineEventAttributes = (CIAppPipelineEventAttributes)o;
        return Objects.equals(this.attributes, ciAppPipelineEventAttributes.attributes) && Objects.equals(this.ciLevel, ciAppPipelineEventAttributes.ciLevel) && Objects.equals(this.tags, ciAppPipelineEventAttributes.tags) && Objects.equals(this.additionalProperties, ciAppPipelineEventAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.ciLevel, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppPipelineEventAttributes {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    ciLevel: ").append(this.toIndentedString(this.ciLevel)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

