/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ContainerImageFlavor;
import com.datadog.api.client.v2.model.ContainerImageVulnerabilities;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"container_count", "image_flavors", "image_tags", "images_built_at", "name", "os_architectures", "os_names", "os_versions", "published_at", "registry", "repo_digest", "repository", "short_image", "sizes", "sources", "tags", "vulnerability_count"})
public class ContainerImageAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONTAINER_COUNT = "container_count";
    private Long containerCount;
    public static final String JSON_PROPERTY_IMAGE_FLAVORS = "image_flavors";
    private List<ContainerImageFlavor> imageFlavors = null;
    public static final String JSON_PROPERTY_IMAGE_TAGS = "image_tags";
    private List<String> imageTags = null;
    public static final String JSON_PROPERTY_IMAGES_BUILT_AT = "images_built_at";
    private List<String> imagesBuiltAt = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OS_ARCHITECTURES = "os_architectures";
    private List<String> osArchitectures = null;
    public static final String JSON_PROPERTY_OS_NAMES = "os_names";
    private List<String> osNames = null;
    public static final String JSON_PROPERTY_OS_VERSIONS = "os_versions";
    private List<String> osVersions = null;
    public static final String JSON_PROPERTY_PUBLISHED_AT = "published_at";
    private String publishedAt;
    public static final String JSON_PROPERTY_REGISTRY = "registry";
    private String registry;
    public static final String JSON_PROPERTY_REPO_DIGEST = "repo_digest";
    private String repoDigest;
    public static final String JSON_PROPERTY_REPOSITORY = "repository";
    private String repository;
    public static final String JSON_PROPERTY_SHORT_IMAGE = "short_image";
    private String shortImage;
    public static final String JSON_PROPERTY_SIZES = "sizes";
    private List<Long> sizes = null;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_VULNERABILITY_COUNT = "vulnerability_count";
    private ContainerImageVulnerabilities vulnerabilityCount;
    private Map<String, Object> additionalProperties;

    public ContainerImageAttributes containerCount(Long containerCount) {
        this.containerCount = containerCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="container_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(Long containerCount) {
        this.containerCount = containerCount;
    }

    public ContainerImageAttributes imageFlavors(List<ContainerImageFlavor> imageFlavors) {
        this.imageFlavors = imageFlavors;
        for (ContainerImageFlavor item : imageFlavors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ContainerImageAttributes addImageFlavorsItem(ContainerImageFlavor imageFlavorsItem) {
        if (this.imageFlavors == null) {
            this.imageFlavors = new ArrayList<ContainerImageFlavor>();
        }
        this.imageFlavors.add(imageFlavorsItem);
        this.unparsed |= imageFlavorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="image_flavors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ContainerImageFlavor> getImageFlavors() {
        return this.imageFlavors;
    }

    public void setImageFlavors(List<ContainerImageFlavor> imageFlavors) {
        this.imageFlavors = imageFlavors;
    }

    public ContainerImageAttributes imageTags(List<String> imageTags) {
        this.imageTags = imageTags;
        return this;
    }

    public ContainerImageAttributes addImageTagsItem(String imageTagsItem) {
        if (this.imageTags == null) {
            this.imageTags = new ArrayList<String>();
        }
        this.imageTags.add(imageTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="image_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getImageTags() {
        return this.imageTags;
    }

    public void setImageTags(List<String> imageTags) {
        this.imageTags = imageTags;
    }

    public ContainerImageAttributes imagesBuiltAt(List<String> imagesBuiltAt) {
        this.imagesBuiltAt = imagesBuiltAt;
        return this;
    }

    public ContainerImageAttributes addImagesBuiltAtItem(String imagesBuiltAtItem) {
        if (this.imagesBuiltAt == null) {
            this.imagesBuiltAt = new ArrayList<String>();
        }
        this.imagesBuiltAt.add(imagesBuiltAtItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="images_built_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getImagesBuiltAt() {
        return this.imagesBuiltAt;
    }

    public void setImagesBuiltAt(List<String> imagesBuiltAt) {
        this.imagesBuiltAt = imagesBuiltAt;
    }

    public ContainerImageAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerImageAttributes osArchitectures(List<String> osArchitectures) {
        this.osArchitectures = osArchitectures;
        return this;
    }

    public ContainerImageAttributes addOsArchitecturesItem(String osArchitecturesItem) {
        if (this.osArchitectures == null) {
            this.osArchitectures = new ArrayList<String>();
        }
        this.osArchitectures.add(osArchitecturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="os_architectures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOsArchitectures() {
        return this.osArchitectures;
    }

    public void setOsArchitectures(List<String> osArchitectures) {
        this.osArchitectures = osArchitectures;
    }

    public ContainerImageAttributes osNames(List<String> osNames) {
        this.osNames = osNames;
        return this;
    }

    public ContainerImageAttributes addOsNamesItem(String osNamesItem) {
        if (this.osNames == null) {
            this.osNames = new ArrayList<String>();
        }
        this.osNames.add(osNamesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="os_names")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOsNames() {
        return this.osNames;
    }

    public void setOsNames(List<String> osNames) {
        this.osNames = osNames;
    }

    public ContainerImageAttributes osVersions(List<String> osVersions) {
        this.osVersions = osVersions;
        return this;
    }

    public ContainerImageAttributes addOsVersionsItem(String osVersionsItem) {
        if (this.osVersions == null) {
            this.osVersions = new ArrayList<String>();
        }
        this.osVersions.add(osVersionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="os_versions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOsVersions() {
        return this.osVersions;
    }

    public void setOsVersions(List<String> osVersions) {
        this.osVersions = osVersions;
    }

    public ContainerImageAttributes publishedAt(String publishedAt) {
        this.publishedAt = publishedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="published_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(String publishedAt) {
        this.publishedAt = publishedAt;
    }

    public ContainerImageAttributes registry(String registry) {
        this.registry = registry;
        return this;
    }

    @Nullable
    @JsonProperty(value="registry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public ContainerImageAttributes repoDigest(String repoDigest) {
        this.repoDigest = repoDigest;
        return this;
    }

    @Nullable
    @JsonProperty(value="repo_digest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRepoDigest() {
        return this.repoDigest;
    }

    public void setRepoDigest(String repoDigest) {
        this.repoDigest = repoDigest;
    }

    public ContainerImageAttributes repository(String repository) {
        this.repository = repository;
        return this;
    }

    @Nullable
    @JsonProperty(value="repository")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public ContainerImageAttributes shortImage(String shortImage) {
        this.shortImage = shortImage;
        return this;
    }

    @Nullable
    @JsonProperty(value="short_image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShortImage() {
        return this.shortImage;
    }

    public void setShortImage(String shortImage) {
        this.shortImage = shortImage;
    }

    public ContainerImageAttributes sizes(List<Long> sizes) {
        this.sizes = sizes;
        return this;
    }

    public ContainerImageAttributes addSizesItem(Long sizesItem) {
        if (this.sizes == null) {
            this.sizes = new ArrayList<Long>();
        }
        this.sizes.add(sizesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sizes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getSizes() {
        return this.sizes;
    }

    public void setSizes(List<Long> sizes) {
        this.sizes = sizes;
    }

    public ContainerImageAttributes sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public ContainerImageAttributes addSourcesItem(String sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public ContainerImageAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ContainerImageAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ContainerImageAttributes vulnerabilityCount(ContainerImageVulnerabilities vulnerabilityCount) {
        this.vulnerabilityCount = vulnerabilityCount;
        this.unparsed |= vulnerabilityCount.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="vulnerability_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContainerImageVulnerabilities getVulnerabilityCount() {
        return this.vulnerabilityCount;
    }

    public void setVulnerabilityCount(ContainerImageVulnerabilities vulnerabilityCount) {
        this.vulnerabilityCount = vulnerabilityCount;
    }

    @JsonAnySetter
    public ContainerImageAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerImageAttributes containerImageAttributes = (ContainerImageAttributes)o;
        return Objects.equals(this.containerCount, containerImageAttributes.containerCount) && Objects.equals(this.imageFlavors, containerImageAttributes.imageFlavors) && Objects.equals(this.imageTags, containerImageAttributes.imageTags) && Objects.equals(this.imagesBuiltAt, containerImageAttributes.imagesBuiltAt) && Objects.equals(this.name, containerImageAttributes.name) && Objects.equals(this.osArchitectures, containerImageAttributes.osArchitectures) && Objects.equals(this.osNames, containerImageAttributes.osNames) && Objects.equals(this.osVersions, containerImageAttributes.osVersions) && Objects.equals(this.publishedAt, containerImageAttributes.publishedAt) && Objects.equals(this.registry, containerImageAttributes.registry) && Objects.equals(this.repoDigest, containerImageAttributes.repoDigest) && Objects.equals(this.repository, containerImageAttributes.repository) && Objects.equals(this.shortImage, containerImageAttributes.shortImage) && Objects.equals(this.sizes, containerImageAttributes.sizes) && Objects.equals(this.sources, containerImageAttributes.sources) && Objects.equals(this.tags, containerImageAttributes.tags) && Objects.equals(this.vulnerabilityCount, containerImageAttributes.vulnerabilityCount) && Objects.equals(this.additionalProperties, containerImageAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.containerCount, this.imageFlavors, this.imageTags, this.imagesBuiltAt, this.name, this.osArchitectures, this.osNames, this.osVersions, this.publishedAt, this.registry, this.repoDigest, this.repository, this.shortImage, this.sizes, this.sources, this.tags, this.vulnerabilityCount, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerImageAttributes {\n");
        sb.append("    containerCount: ").append(this.toIndentedString(this.containerCount)).append("\n");
        sb.append("    imageFlavors: ").append(this.toIndentedString(this.imageFlavors)).append("\n");
        sb.append("    imageTags: ").append(this.toIndentedString(this.imageTags)).append("\n");
        sb.append("    imagesBuiltAt: ").append(this.toIndentedString(this.imagesBuiltAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    osArchitectures: ").append(this.toIndentedString(this.osArchitectures)).append("\n");
        sb.append("    osNames: ").append(this.toIndentedString(this.osNames)).append("\n");
        sb.append("    osVersions: ").append(this.toIndentedString(this.osVersions)).append("\n");
        sb.append("    publishedAt: ").append(this.toIndentedString(this.publishedAt)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    repoDigest: ").append(this.toIndentedString(this.repoDigest)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    shortImage: ").append(this.toIndentedString(this.shortImage)).append("\n");
        sb.append("    sizes: ").append(this.toIndentedString(this.sizes)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    vulnerabilityCount: ").append(this.toIndentedString(this.vulnerabilityCount)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

