/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Config;
import datadog.trace.api.UserEventTrackingMode;
import java.util.concurrent.atomic.AtomicReference;

public enum UserIdCollectionMode {
    IDENTIFICATION("identification", "ident"),
    ANONYMIZATION("anonymization", "anon"),
    DISABLED("disabled");

    private static final AtomicReference<UserIdCollectionMode> CURRENT_MODE;
    private final String[] values;

    private UserIdCollectionMode(String ... values) {
        this.values = values;
    }

    public static UserIdCollectionMode fromString(String collectionMode, String trackingMode) {
        return CURRENT_MODE.updateAndGet(current -> {
            if (collectionMode == null && trackingMode != null) {
                return UserIdCollectionMode.fromTracking(trackingMode);
            }
            return UserIdCollectionMode.fromMode(collectionMode);
        });
    }

    public static UserIdCollectionMode fromRemoteConfig(String mode) {
        return CURRENT_MODE.updateAndGet(current -> {
            if (mode == null) {
                return Config.get().getAppSecUserIdCollectionMode();
            }
            return UserIdCollectionMode.fromMode(mode);
        });
    }

    private static UserIdCollectionMode fromMode(String mode) {
        if (mode == null || IDENTIFICATION.matches(mode)) {
            return IDENTIFICATION;
        }
        if (ANONYMIZATION.matches(mode)) {
            return ANONYMIZATION;
        }
        return DISABLED;
    }

    private static UserIdCollectionMode fromTracking(String tracking) {
        switch (UserEventTrackingMode.fromString(tracking)) {
            case SAFE: {
                return ANONYMIZATION;
            }
            case EXTENDED: {
                return IDENTIFICATION;
            }
        }
        return DISABLED;
    }

    private boolean matches(String mode) {
        for (String value : this.values) {
            if (!value.equalsIgnoreCase(mode)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.values[0];
    }

    public static UserIdCollectionMode get() {
        return CURRENT_MODE.get();
    }

    static {
        CURRENT_MODE = new AtomicReference<UserIdCollectionMode>(IDENTIFICATION);
    }
}

