/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.sampling;

import datadog.trace.api.Config;

public class SamplingMechanism {
    public static final byte UNKNOWN = -1;
    public static final byte DEFAULT = 0;
    public static final byte AGENT_RATE = 1;
    public static final byte REMOTE_AUTO_RATE = 2;
    public static final byte LOCAL_USER_RULE = 3;
    public static final byte MANUAL = 4;
    public static final byte APPSEC = 5;
    public static final byte REMOTE_USER_RATE = 6;
    public static final byte SPAN_SAMPLING_RATE = 8;
    public static final byte DATA_JOBS = 10;
    public static final byte REMOTE_USER_RULE = 11;
    public static final byte REMOTE_ADAPTIVE_RULE = 12;
    public static final byte EXTERNAL_OVERRIDE = -128;

    public static boolean validateWithSamplingPriority(int mechanism, int priority) {
        switch (mechanism) {
            case -1: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: {
                return priority == 0 || priority == 1;
            }
            case 3: 
            case 4: 
            case 6: {
                return priority == -1 || priority == 2;
            }
            case 5: {
                return priority == 2 || priority == 0 || priority == 1;
            }
            case 10: {
                return priority == 2;
            }
            case -128: {
                return false;
            }
        }
        return true;
    }

    public static boolean canAvoidSamplingPriorityLock(int priority, int mechanism) {
        return Config.get().isAppSecStandaloneEnabled() && mechanism == 5;
    }

    private SamplingMechanism() {
    }
}

