/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch.encoding;

import ddtrot.com.datadoghq.sketch.ddsketch.encoding.GrowingByteArrayOutput;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Input;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Output;
import java.io.IOException;

public final class VarEncodingHelper {
    private static final int MAX_VAR_LEN_64 = 9;
    private static final int VAR_DOUBLE_ROTATE_DISTANCE = 6;
    private static final byte[] UNSIGNED_VAR_LONG_LENGTHS = new byte[65];
    private static final byte[] VAR_DOUBLE_LENGTHS = new byte[65];

    private VarEncodingHelper() {
    }

    public static void encodeUnsignedVarLong(Output output, long value) throws IOException {
        int length = (63 - Long.numberOfLeadingZeros(value)) / 7;
        for (int i = 0; i < length && i < 8; ++i) {
            output.writeByte((byte)(value | 0x80L));
            value >>>= 7;
        }
        output.writeByte((byte)value);
    }

    public static long decodeUnsignedVarLong(Input input) throws IOException {
        long value = 0L;
        int shift = 0;
        byte next;
        while ((next = input.readByte()) < 0 && shift != 56) {
            value |= ((long)next & 0x7FL) << shift;
            shift += 7;
        }
        return value | (long)next << shift;
    }

    public static byte unsignedVarLongEncodedLength(long value) {
        return UNSIGNED_VAR_LONG_LENGTHS[Long.numberOfLeadingZeros(value)];
    }

    public static void encodeSignedVarLong(Output output, long value) throws IOException {
        VarEncodingHelper.encodeUnsignedVarLong(output, VarEncodingHelper.zigZagEncode(value));
    }

    public static long decodeSignedVarLong(Input input) throws IOException {
        return VarEncodingHelper.zigZagDecode(VarEncodingHelper.decodeUnsignedVarLong(input));
    }

    public static byte signedVarLongEncodedLength(long value) {
        return UNSIGNED_VAR_LONG_LENGTHS[Long.numberOfLeadingZeros(VarEncodingHelper.zigZagEncode(value))];
    }

    private static long zigZagEncode(long value) {
        return value >> 63 ^ value << 1;
    }

    private static long zigZagDecode(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    public static void encodeVarDouble(Output output, double value) throws IOException {
        long bits = VarEncodingHelper.doubleToVarBits(value);
        for (int i = 0; i < 8; ++i) {
            byte next = (byte)(bits >>> 57);
            if ((bits <<= 7) == 0L) {
                output.writeByte(next);
                return;
            }
            output.writeByte((byte)((long)next | 0x80L));
        }
        output.writeByte((byte)(bits >>> 56));
    }

    public static double decodeVarDouble(Input input) throws IOException {
        long bits = 0L;
        int shift = 57;
        while (true) {
            byte next = input.readByte();
            if (shift == 1) {
                bits |= Byte.toUnsignedLong(next);
                break;
            }
            if (next >= 0) {
                bits |= (long)next << shift;
                break;
            }
            bits |= ((long)next & 0x7FL) << shift;
            shift -= 7;
        }
        return VarEncodingHelper.varBitsToDouble(bits);
    }

    public static byte varDoubleEncodedLength(double value) {
        return VAR_DOUBLE_LENGTHS[Long.numberOfTrailingZeros(VarEncodingHelper.doubleToVarBits(value))];
    }

    private static long doubleToVarBits(double value) {
        return Long.rotateLeft(Double.doubleToRawLongBits(value + 1.0) - Double.doubleToRawLongBits(1.0), 6);
    }

    private static double varBitsToDouble(long bits) {
        return Double.longBitsToDouble(Long.rotateRight(bits, 6) + Double.doubleToRawLongBits(1.0)) - 1.0;
    }

    static {
        GrowingByteArrayOutput output = GrowingByteArrayOutput.withInitialCapacity(9);
        for (int numLeadingZeros = 0; numLeadingZeros <= 64; ++numLeadingZeros) {
            output.clear();
            try {
                VarEncodingHelper.encodeUnsignedVarLong(output, numLeadingZeros == 64 ? 0L : -1L >>> numLeadingZeros);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VarEncodingHelper.UNSIGNED_VAR_LONG_LENGTHS[numLeadingZeros] = (byte)output.trimmedCopy().length;
        }
        for (int numTrailingZeros = 0; numTrailingZeros <= 64; ++numTrailingZeros) {
            output.clear();
            try {
                VarEncodingHelper.encodeVarDouble(output, VarEncodingHelper.varBitsToDouble(numTrailingZeros == 64 ? 0L : -1L << numTrailingZeros));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VarEncodingHelper.VAR_DOUBLE_LENGTHS[numTrailingZeros] = (byte)output.trimmedCopy().length;
        }
    }
}

