/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.util;

public class Cookie {
    private final String cookieName;
    private final String cookieValue;
    private final boolean secure;
    private final String sameSite;
    private final boolean httpOnly;
    private final Integer expiresYear;
    private final Integer maxAge;

    public Cookie(String cookieName, String cookieValue, boolean secure, boolean httpOnly, String sameSite, Integer expiresYear, Integer maxAge) {
        this.cookieName = cookieName;
        this.cookieValue = cookieValue;
        this.secure = secure;
        this.sameSite = sameSite;
        this.httpOnly = httpOnly;
        this.expiresYear = expiresYear;
        this.maxAge = maxAge;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Integer getExpiresYear() {
        return this.expiresYear;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public static Builder named(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String value;
        private boolean secure = false;
        private boolean httpOnly = false;
        private String sameSite = null;
        private Integer expiresYear = null;
        private Integer maxAge = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder sameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Builder expiresYear(Integer expiresYear) {
            this.expiresYear = expiresYear;
            return this;
        }

        public Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.secure, this.httpOnly, this.sameSite, this.expiresYear, this.maxAge);
        }
    }
}

