/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.naming.v0.NamingSchemaV0;
import ddtrot.dd.trace.api.naming.v1.NamingSchemaV1;
import javax.annotation.Nonnull;

public class SpanNaming {
    public static final int SCHEMA_MIN_VERSION = 0;
    public static final int SCHEMA_MAX_VERSION = 1;
    private final NamingSchema namingSchema;
    private final int version;

    public static SpanNaming instance() {
        return Singleton.INSTANCE;
    }

    private SpanNaming() {
        this(Config.get().getSpanAttributeSchemaVersion());
    }

    private SpanNaming(int version) {
        this.version = version;
        switch (version) {
            case 1: {
                this.namingSchema = new NamingSchemaV1();
                break;
            }
            default: {
                this.namingSchema = new NamingSchemaV0();
            }
        }
    }

    @Nonnull
    public NamingSchema namingSchema() {
        return this.namingSchema;
    }

    public int version() {
        return this.version;
    }

    private static class Singleton {
        private static SpanNaming INSTANCE = new SpanNaming();

        private Singleton() {
        }
    }
}

