/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.time;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TimeUtils {
    private static final Pattern SIMPLE_DELAY_PATTERN = Pattern.compile("(\\d+)([HhMmSs]?)");

    public static long parseSimpleDelay(String delayString) {
        Matcher delayMatcher;
        if (null != delayString && (delayMatcher = SIMPLE_DELAY_PATTERN.matcher(delayString)).matches()) {
            long delay = Integer.parseInt(delayMatcher.group(1));
            String unit = delayMatcher.group(2);
            if ("H".equalsIgnoreCase(unit)) {
                return TimeUnit.HOURS.toSeconds(delay);
            }
            if ("M".equalsIgnoreCase(unit)) {
                return TimeUnit.MINUTES.toSeconds(delay);
            }
            return delay;
        }
        return -1L;
    }

    private TimeUtils() {
    }
}

